/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.SAXException;
import repast.simphony.batch.ProcessOutputWriter;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.parameter.ParametersToInput;
import repast.simphony.util.FileUtils;
import simphony.util.messages.MessageCenter;

public class LocalDriver {
    private static MessageCenter msg = MessageCenter.getMessageCenter(LocalDriver.class);
    private ExecutorService executor;
    private List<Future<Void>> futures;
    private List<Instance> instances = new ArrayList<Instance>();

    private File unrollXMLParamsIntoFile(File workingDir, File batchParamFile) throws IOException {
        ParametersToInput toInput;
        try {
            toInput = new ParametersToInput(batchParamFile);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        File input = new File(workingDir, "batch_parameters_input.txt");
        toInput.formatForInput(input, new File(workingDir, "parameters_for_run.csv"));
        return input;
    }

    private void writeInput(String input, File file) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void run(String propsFile) throws IOException {
        Properties props = new Properties();
        File in = new File("./MessageCenter.log4j.properties");
        props.load(new FileInputStream(in));
        PropertyConfigurator.configure((Properties)props);
        props = new Properties();
        props.load(new FileReader(propsFile));
        File wd = new File(props.getProperty("working.directory"));
        int instanceCount = Integer.parseInt(props.getProperty("instance.count", "1"));
        File batchParamFile = new File(props.getProperty("batch.parameter.file")).getCanonicalFile();
        List<String> inputs = null;
        if (props.getProperty("unrolled.batch.parameter.file", "").length() > 0) {
            inputs = this.createInputArgs(instanceCount, new File(props.getProperty("unrolled.batch.parameter.file")));
        } else {
            File file = this.unrollXMLParamsIntoFile(wd, batchParamFile);
            inputs = this.createInputArgs(instanceCount, file);
        }
        File scenario = new File(props.getProperty("scenario.directory")).getCanonicalFile();
        File libDir = new File(props.getProperty("repast.lib.directory")).getCanonicalFile();
        this.futures = new ArrayList<Future<Void>>();
        this.executor = Executors.newFixedThreadPool(instanceCount);
        File file = new File("./DONE");
        file.delete();
        String vmArgs = props.getProperty("vm.arguments", "");
        boolean mkSymLink = new File("./data").exists();
        try {
            int i = 0;
            while (i < instanceCount) {
                int id = i + 1;
                File subwd = new File(wd, "instance_" + id).getCanonicalFile();
                subwd.mkdirs();
                if (mkSymLink && SystemUtils.IS_OS_WINDOWS_XP) {
                    FileUtils.copyDirs((File)new File(subwd.getParentFile(), "data"), (File)new File(subwd, "data"));
                } else if (mkSymLink) {
                    this.makeSymLink(subwd);
                }
                this.instances.add(new Instance(id, subwd));
                String input = inputs.get(i);
                File inputFile = new File(subwd, "param_input.txt");
                this.writeInput(input, inputFile);
                this.runInstance(vmArgs, inputFile.getCanonicalPath(), libDir, batchParamFile, scenario, subwd, String.valueOf(id));
                ++i;
            }
            for (Future<Void> future : this.futures) {
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    ex.getCause().printStackTrace();
                    msg.error((Object)"", (Throwable)ex, new Object[0]);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    msg.error((Object)"", (Throwable)ex, new Object[0]);
                }
            }
        }
        finally {
            this.executor.shutdown();
            this.createStatusOutput();
            file.createNewFile();
        }
    }

    private void makeSymLink(File instanceDir) {
        Process p;
        ProcessBuilder builder2;
        int exitCode = 1;
        try {
            builder2 = new ProcessBuilder(new String[0]);
            builder2.directory(instanceDir);
            builder2.redirectErrorStream(true);
            builder2.command("cmd", "/c", "mklink", "/D", "/J", "\"" + new File(instanceDir, "data").getCanonicalPath() + "\"", "\"" + new File(instanceDir.getParentFile(), "data").getCanonicalPath() + "\"");
            p = builder2.start();
            exitCode = p.waitFor();
        }
        catch (InterruptedException builder2) {
        }
        catch (IOException builder2) {
            // empty catch block
        }
        if (exitCode != 0) {
            try {
                builder2 = new ProcessBuilder(new String[0]);
                builder2.directory(instanceDir);
                builder2.redirectErrorStream(true);
                builder2.command("ln", "-s", new File(instanceDir.getParentFile(), "data").getCanonicalPath(), new File(instanceDir, "data").getCanonicalPath());
                p = builder2.start();
                exitCode = p.waitFor();
                if (exitCode != 0) {
                    msg.error((Object)("Error while creating symlinks to data directory. Error = " + exitCode), (Throwable)new RuntimeException(), new Object[0]);
                }
            }
            catch (InterruptedException builder3) {
            }
            catch (IOException ex) {
                msg.error((Object)"Error while creating symlinks to data directory", (Throwable)ex, new Object[0]);
            }
        }
    }

    private void createStatusOutput() throws IOException {
        Properties props = new Properties();
        for (Instance instance : this.instances) {
            String suffix = "_" + instance.id;
            RunningStatus status = RunningStatus.OK;
            File file = new File(instance.wd, String.valueOf(RunningStatus.FAILURE.toString()) + suffix);
            if (file.exists()) {
                status = RunningStatus.FAILURE;
            } else {
                file = new File(instance.wd, String.valueOf(RunningStatus.WARN.toString()) + suffix);
                if (file.exists()) {
                    status = RunningStatus.WARN;
                }
            }
            props.put(String.valueOf(instance.id), status.toString());
        }
        props.store(new FileOutputStream("status_output.properties"), "");
    }

    private List<String> createInputArgs(int instances, File input) throws IOException {
        List<String> lines = this.createParameterStrings(input);
        ArrayList<StringBuilder> inputs = new ArrayList<StringBuilder>();
        int i = 0;
        while (i < instances) {
            inputs.add(new StringBuilder());
            ++i;
        }
        i = 0;
        for (String line : lines) {
            StringBuilder builder = (StringBuilder)inputs.get(i);
            builder.append(line);
            builder.append("\n");
            if (++i != instances) continue;
            i = 0;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (StringBuilder builder : inputs) {
            list.add(builder.toString());
        }
        return list;
    }

    private List<String> createParameterStrings(File input) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(input));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                list.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return list;
    }

    private void runInstance(String vmArgs, String inputArg, File libDir, File batchParamFile, File scenarioFile, File workingDirectory, String id) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(workingDirectory);
        if (vmArgs.length() > 0) {
            builder.command("java", vmArgs, "-cp", String.valueOf(libDir.getCanonicalPath()) + "/*", "repast.simphony.batch.InstanceRunner", "-pxml", batchParamFile.getCanonicalPath(), "-scenario", scenarioFile.getCanonicalPath(), "-pinput", inputArg, "-id", id);
        } else {
            builder.command("java", "-cp", String.valueOf(libDir.getCanonicalPath()) + "/*", "repast.simphony.batch.InstanceRunner", "-pxml", batchParamFile.getCanonicalPath(), "-scenario", scenarioFile.getCanonicalPath(), "-pinput", inputArg, "-id", id);
        }
        builder.redirectErrorStream(true);
        ProcessRunner runner = new ProcessRunner(builder, new File(workingDirectory, "instance.log"));
        this.futures.add(this.executor.submit(runner));
    }

    public static void main(String[] args) {
        LocalDriver driver = new LocalDriver();
        try {
            driver.run(args[0]);
        }
        catch (IOException e) {
            msg.error((Object)"", (Throwable)e, new Object[0]);
        }
    }

    private static class Instance {
        int id;
        File wd;

        public Instance(int id, File wd) {
            this.id = id;
            this.wd = wd;
        }
    }

    private static class ProcessRunner
    implements Callable<Void> {
        ProcessOutputWriter writer;
        ProcessBuilder builder;

        public ProcessRunner(ProcessBuilder builder, File log) {
            this.writer = new ProcessOutputWriter(log, true);
            this.builder = builder;
        }

        @Override
        public Void call() throws IOException {
            Process process = this.builder.start();
            this.writer.captureOutput(process);
            return null;
        }
    }
}

