/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Assert;
import org.junit.Test;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.DefaultOutputPatternCreator;
import repast.simphony.batch.ssh.LocalOutputFinder;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.RemoteOutputFinderCopier;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.Session;
import repast.simphony.batch.ssh.StatusException;

public class FindOutputTests {
    private static final String[] ONE_EXP;
    private static final String[] TWO_EXP;
    private static final String[] ONE_BP_EXP;
    private static final String[] TWO_BP_EXP;
    private static final String[] OTHER_EXP;

    static {
        PropertyConfigurator.configure((String)"./config/SSH.MessageCenter.log4j.properties");
        String home = System.getProperty("user.home");
        SSHSessionFactory.init(String.valueOf(home) + "/.ssh");
        ONE_EXP = new String[]{"instance_1/one", "instance_2/one"};
        TWO_EXP = new String[]{"instance_1/output/two.txt", "instance_2/output/two.txt"};
        ONE_BP_EXP = new String[]{"instance_1/one.batch_param_map", "instance_2/one.batch_param_map"};
        TWO_BP_EXP = new String[]{"instance_1/output/two.batch_param_map.txt", "instance_2/output/two.batch_param_map.txt"};
        OTHER_EXP = new String[]{"instance_1/output/more_output/some_output123.txt", "instance_2/output/more_output/some_output345.txt"};
    }

    private Set<String> createSet(String prefix, String[] expected) {
        HashSet<String> set = new HashSet<String>();
        File file = new File(prefix);
        String[] stringArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            set.add(new File(file, f).getAbsolutePath().replace("\\", "/"));
            ++n2;
        }
        return set;
    }

    @Test
    public void matchTests() {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**/foo*.txt");
        Assert.assertTrue((boolean)matcher.matches(new File("a/b/c/foo_abc.txt").toPath()));
        Assert.assertTrue((!matcher.matches(new File("a/b/c/abc.txt").toPath()) ? 1 : 0) != 0);
    }

    private void testFoundFiles(String msg, MatchedFiles mf, String prefix, String[] exp) {
        Set<String> set = this.createSet(prefix, exp);
        for (File file : mf.getFiles()) {
            String f = file.getAbsolutePath().replace("\\", "/");
            Assert.assertTrue((String)(String.valueOf(msg) + ": " + f), (boolean)set.remove(f));
        }
        Assert.assertEquals((long)0L, (long)set.size());
    }

    @Test
    public void findViaBatchParam() throws StatusException {
        LocalOutputFinder finder = new LocalOutputFinder();
        DefaultOutputPatternCreator creator = new DefaultOutputPatternCreator("one", true);
        OutputPattern onePattern = creator.getFileSinkOutputPattern();
        OutputPattern oneBPPattern = creator.getParamMapPattern();
        finder.addPattern(oneBPPattern);
        finder.addPattern(onePattern);
        creator = new DefaultOutputPatternCreator("two.txt", true);
        OutputPattern twoPattern = creator.getFileSinkOutputPattern();
        OutputPattern twoBPPattern = creator.getParamMapPattern();
        finder.addPattern(twoBPPattern);
        finder.addPattern(twoPattern);
        List<MatchedFiles> files = finder.run(new File("./test_data"));
        Assert.assertEquals((long)4L, (long)files.size());
        boolean[] found = new boolean[4];
        for (MatchedFiles mf : files) {
            if (mf.getPattern().equals(onePattern)) {
                this.testFoundFiles("one", mf, "./test_data", ONE_EXP);
                found[0] = true;
                continue;
            }
            if (mf.getPattern().equals(twoPattern)) {
                this.testFoundFiles("two", mf, "./test_data", TWO_EXP);
                found[1] = true;
                continue;
            }
            if (mf.getPattern().equals(oneBPPattern)) {
                this.testFoundFiles("one bp", mf, "./test_data", ONE_BP_EXP);
                found[2] = true;
                continue;
            }
            if (mf.getPattern().equals(twoBPPattern)) {
                this.testFoundFiles("two bp", mf, "./test_data", TWO_BP_EXP);
                found[3] = true;
                continue;
            }
            Assert.fail((String)"bad pattern");
        }
        int i = 0;
        while (i < found.length) {
            Assert.assertTrue((String)("matched files " + i + "not tested"), (boolean)found[i]);
            ++i;
        }
    }

    @Test
    public void testPattern() throws StatusException {
        LocalOutputFinder finder = new LocalOutputFinder();
        DefaultOutputPatternCreator creator = new DefaultOutputPatternCreator("one", true);
        OutputPattern onePattern = creator.getFileSinkOutputPattern();
        OutputPattern oneBPPattern = creator.getParamMapPattern();
        finder.addPattern(oneBPPattern);
        finder.addPattern(onePattern);
        creator = new DefaultOutputPatternCreator("two.txt", true);
        OutputPattern twoPattern = creator.getFileSinkOutputPattern();
        OutputPattern twoBPPattern = creator.getParamMapPattern();
        finder.addPattern(twoBPPattern);
        finder.addPattern(twoPattern);
        OutputPattern otherPattern = new OutputPattern();
        otherPattern.setPattern("**/more_output/some_output*.txt");
        otherPattern.setPath("some_output.txt");
        finder.addPattern(otherPattern);
        List<MatchedFiles> files = finder.run(new File("./test_data"));
        Assert.assertEquals((long)5L, (long)files.size());
        boolean[] found = new boolean[5];
        for (MatchedFiles mf : files) {
            if (mf.getPattern().equals(onePattern)) {
                this.testFoundFiles("one", mf, "./test_data", ONE_EXP);
                found[0] = true;
                continue;
            }
            if (mf.getPattern().equals(twoPattern)) {
                this.testFoundFiles("two", mf, "./test_data", TWO_EXP);
                found[1] = true;
                continue;
            }
            if (mf.getPattern().equals(oneBPPattern)) {
                this.testFoundFiles("one bp", mf, "./test_data", ONE_BP_EXP);
                found[2] = true;
                continue;
            }
            if (mf.getPattern().equals(twoBPPattern)) {
                this.testFoundFiles("two bp", mf, "./test_data", TWO_BP_EXP);
                found[3] = true;
                continue;
            }
            if (mf.getPattern().equals(otherPattern)) {
                this.testFoundFiles("other", mf, "./test_data", OTHER_EXP);
                found[4] = true;
                continue;
            }
            Assert.fail((String)"bad pattern");
        }
        int i = 0;
        while (i < found.length) {
            Assert.assertTrue((String)("matched files " + i + "not tested"), (boolean)found[i]);
            ++i;
        }
    }

    private Session getTestingRemote(Configuration config) {
        for (Session session : config.sessions()) {
            if (!session.getUser().equals("sshtesting")) continue;
            return session;
        }
        return null;
    }

    @Test
    public void testRemoteFinder() throws IOException, StatusException {
        Configuration config = new Configuration("./test_data/test_remote_config.properties");
        RemoteSession remote = (RemoteSession)this.getTestingRemote(config);
        RemoteOutputFinderCopier finder = new RemoteOutputFinderCopier();
        DefaultOutputPatternCreator creator = new DefaultOutputPatternCreator("one", true);
        OutputPattern onePattern = creator.getFileSinkOutputPattern();
        OutputPattern oneBPPattern = creator.getParamMapPattern();
        finder.addPattern(oneBPPattern);
        finder.addPattern(onePattern);
        creator = new DefaultOutputPatternCreator("two.txt", true);
        OutputPattern twoPattern = creator.getFileSinkOutputPattern();
        OutputPattern twoBPPattern = creator.getParamMapPattern();
        finder.addPattern(twoBPPattern);
        finder.addPattern(twoPattern);
        OutputPattern otherPattern = new OutputPattern();
        otherPattern.setPattern("**/more_output/some_output*.txt");
        otherPattern.setPath("some_output.txt");
        finder.addPattern(otherPattern);
        Path local = Files.createTempDirectory(String.valueOf(System.currentTimeMillis()), new FileAttribute[0]);
        List<MatchedFiles> files = finder.run(remote, "for_testing_simphony_model2", local.toString());
        Assert.assertEquals((long)5L, (long)files.size());
        String prefix = String.valueOf(local.toString()) + "/for_testing_simphony_model2";
        boolean[] found = new boolean[5];
        for (MatchedFiles mf : files) {
            if (mf.getPattern().equals(onePattern)) {
                this.testFoundFiles("one", mf, prefix, ONE_EXP);
                found[0] = true;
                continue;
            }
            if (mf.getPattern().equals(twoPattern)) {
                this.testFoundFiles("two", mf, prefix, TWO_EXP);
                found[1] = true;
                continue;
            }
            if (mf.getPattern().equals(oneBPPattern)) {
                this.testFoundFiles("one bp", mf, prefix, ONE_BP_EXP);
                found[2] = true;
                continue;
            }
            if (mf.getPattern().equals(twoBPPattern)) {
                this.testFoundFiles("two bp", mf, prefix, TWO_BP_EXP);
                found[3] = true;
                continue;
            }
            if (mf.getPattern().equals(otherPattern)) {
                this.testFoundFiles("other", mf, prefix, OTHER_EXP);
                found[4] = true;
                continue;
            }
            Assert.fail((String)"bad pattern");
        }
        int i = 0;
        while (i < found.length) {
            Assert.assertTrue((String)("matched files " + i + "not tested"), (boolean)found[i]);
            ++i;
        }
    }
}

