/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.engine;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.data2.BatchParamMapFileWriter;
import repast.simphony.data2.DataSetManager;
import repast.simphony.data2.DataSetRegistry;
import repast.simphony.data2.builder.DataSetBuilder;
import repast.simphony.data2.builder.FileDataSinkBuilder;
import repast.simphony.data2.builder.FileNameFormatter;
import repast.simphony.data2.engine.FileSinkDescriptor;
import repast.simphony.engine.controller.DescriptorControllerAction;
import repast.simphony.engine.environment.DefaultControllerAction;
import repast.simphony.engine.environment.RunState;
import repast.simphony.parameter.Parameters;
import simphony.util.messages.MessageCenter;

public class FileSinkComponentControllerAction
extends DefaultControllerAction
implements DescriptorControllerAction<FileSinkDescriptor> {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(FileSinkComponentControllerAction.class);
    private FileSinkDescriptor descriptor;
    private List<BatchParamMapFileWriter> writers = new ArrayList<BatchParamMapFileWriter>();

    public FileSinkComponentControllerAction(FileSinkDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public FileSinkDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void runInitialize(RunState runState, Object contextId, Parameters params) {
        for (BatchParamMapFileWriter writer : this.writers) {
            writer.runStarted();
        }
    }

    public void batchCleanup(RunState runState, Object contextId) {
        this.writers.clear();
    }

    public void batchInitialize(RunState runState, Object contextId) {
        DataSetRegistry registry = (DataSetRegistry)runState.getFromRegistry((Object)"repast.simphony.data.logging.registry");
        DataSetManager manager = registry.getDataSetManager(contextId);
        DataSetBuilder<?> builder = manager.getDataSetBuilder(this.descriptor.getDataSet());
        if (builder == null) {
            msgCenter.error((Object)("Error while creating FileDataSink. DataSet '" + this.descriptor.getDataSet() + "' not found"), (Throwable)new NullPointerException(), new Object[0]);
        } else {
            FileNameFormatter fnFormatter = new FileNameFormatter(this.descriptor.getFileName(), this.descriptor.isAddTimeStamp());
            FileDataSinkBuilder sinkBuilder = new FileDataSinkBuilder(this.descriptor.getName(), fnFormatter, this.descriptor.getDelimiter(), this.descriptor.getFormat());
            if (runState.getRunInfo().isBatch() && !this.descriptor.getSourceIds().contains("run")) {
                sinkBuilder.addSource("run");
            }
            for (String sourceId : this.descriptor.getSourceIds()) {
                sinkBuilder.addSource(sourceId);
            }
            builder.addFileDataSinkBuilder(sinkBuilder);
            if (runState.getRunInfo().isBatch()) {
                BatchParamMapFileWriter writer = new BatchParamMapFileWriter(manager.getBatchRunDataSource(), fnFormatter, this.descriptor.getDelimiter(), this.descriptor.getFormat());
                builder.addDataSink(writer);
                this.writers.add(writer);
            }
        }
    }
}

