/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.engine;

import repast.simphony.data2.AggregateDataSource;
import repast.simphony.data2.DataSetManager;
import repast.simphony.data2.DataSetRegistry;
import repast.simphony.data2.NonAggregateDataSource;
import repast.simphony.data2.builder.AggregateDataSetBuilder;
import repast.simphony.data2.builder.NonAggregateDataSetBuilder;
import repast.simphony.data2.engine.AggregateDataSourceWrapper;
import repast.simphony.data2.engine.CountSourceDefinition;
import repast.simphony.data2.engine.CustomDataSourceDefinition;
import repast.simphony.data2.engine.DataSetDescriptor;
import repast.simphony.data2.engine.MethodDataSourceDefinition;
import repast.simphony.data2.engine.NonAggregateDataSourceWrapper;
import repast.simphony.engine.controller.DescriptorControllerAction;
import repast.simphony.engine.environment.DefaultControllerAction;
import repast.simphony.engine.environment.RunState;
import simphony.util.messages.MessageCenter;

public class DataSetComponentControllerAction
extends DefaultControllerAction
implements DescriptorControllerAction<DataSetDescriptor> {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(DataSetComponentControllerAction.class);
    private DataSetDescriptor descriptor;

    public DataSetComponentControllerAction(DataSetDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public DataSetDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void batchInitialize(RunState runState, Object contextId) {
        DataSetRegistry registry = (DataSetRegistry)runState.getFromRegistry((Object)"repast.simphony.data.logging.registry");
        DataSetManager manager = registry.getDataSetManager(contextId);
        DataSetDescriptor.DataSetType type = this.descriptor.getType();
        try {
            if (type == DataSetDescriptor.DataSetType.NON_AGGREGATE) {
                NonAggregateDataSetBuilder builder = this.createNABuilder();
                manager.addDataSetBuilder(builder);
                if (this.descriptor.includeTick()) {
                    builder.addDataSource(manager.getTickCountDataSource());
                }
                if (runState.getRunInfo().isBatch() || this.descriptor.includeBatchRun()) {
                    builder.addDataSource(manager.getBatchRunDataSource());
                }
                if (this.descriptor.includeRandomSeed()) {
                    builder.addDataSource(manager.getRandomSeedDataSource());
                }
                builder.defineScheduleParameters(this.descriptor.getScheduleParameters(), this.descriptor.isScheduleAtEnd());
            } else {
                AggregateDataSetBuilder builder = this.createAggregateBuilder();
                manager.addDataSetBuilder(builder);
                if (this.descriptor.includeTick()) {
                    builder.addDataSource(manager.getTickCountDataSource());
                }
                if (runState.getRunInfo().isBatch() || this.descriptor.includeBatchRun()) {
                    builder.addDataSource(manager.getBatchRunDataSource());
                }
                if (this.descriptor.includeRandomSeed()) {
                    builder.addDataSource(manager.getRandomSeedDataSource());
                }
                builder.defineScheduleParameters(this.descriptor.getScheduleParameters(), this.descriptor.isScheduleAtEnd());
            }
        }
        catch (ClassNotFoundException ex) {
            msgCenter.warn((Object)"Error while creating DataSets", (Throwable)ex, new Object[0]);
        }
    }

    private AggregateDataSetBuilder createAggregateBuilder() throws ClassNotFoundException {
        Class<?> objType;
        AggregateDataSetBuilder builder = new AggregateDataSetBuilder(this.descriptor.getName());
        for (MethodDataSourceDefinition methodDataSourceDefinition : this.descriptor.methodDataSources()) {
            objType = Class.forName(methodDataSourceDefinition.getObjTargetClass(), false, ((Object)((Object)this)).getClass().getClassLoader());
            builder.defineMethodDataSource(methodDataSourceDefinition.getId(), methodDataSourceDefinition.getAggregateOp(), objType, methodDataSourceDefinition.getMethodName());
        }
        for (CountSourceDefinition countSourceDefinition : this.descriptor.countDataSources()) {
            objType = Class.forName(countSourceDefinition.getTypeName(), false, ((Object)((Object)this)).getClass().getClassLoader());
            builder.defineCountDataSource(countSourceDefinition.getId(), objType);
        }
        for (CustomDataSourceDefinition customDataSourceDefinition : this.descriptor.customAggDataSources()) {
            String className = customDataSourceDefinition.getDataSourceClassName();
            try {
                Class<?> clazz = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
                if (!AggregateDataSource.class.isAssignableFrom(clazz)) {
                    msgCenter.warn((Object)("Error while creating custom aggregate data source. '" + className + "' must implement AggregateDataSource."), new Object[0]);
                }
                AggregateDataSource source = (AggregateDataSource)clazz.newInstance();
                builder.addDataSource(new AggregateDataSourceWrapper(customDataSourceDefinition.getId(), source));
            }
            catch (Exception ex) {
                msgCenter.warn((Object)("Error while creating custom aggregate data source '" + className + "'"), (Throwable)ex, new Object[0]);
                break;
            }
        }
        return builder;
    }

    private NonAggregateDataSetBuilder createNABuilder() throws ClassNotFoundException {
        Class<?> clazz = Class.forName(this.descriptor.getSourceType(), false, ((Object)((Object)this)).getClass().getClassLoader());
        NonAggregateDataSetBuilder builder = new NonAggregateDataSetBuilder(this.descriptor.getName(), clazz);
        for (MethodDataSourceDefinition methodDataSourceDefinition : this.descriptor.methodDataSources()) {
            Class<?> objType = Class.forName(methodDataSourceDefinition.getObjTargetClass(), false, ((Object)((Object)this)).getClass().getClassLoader());
            builder.defineMethodDataSource(methodDataSourceDefinition.getId(), objType, methodDataSourceDefinition.getMethodName());
        }
        for (CustomDataSourceDefinition customDataSourceDefinition : this.descriptor.customNonAggDataSources()) {
            String className = customDataSourceDefinition.getDataSourceClassName();
            try {
                Class<?> dsClass = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
                if (!NonAggregateDataSource.class.isAssignableFrom(dsClass)) {
                    msgCenter.warn((Object)("Error while creating custom non-aggregate data source. '" + className + "' must implement NonAggregateDataSource."), new Object[0]);
                }
                NonAggregateDataSource source = (NonAggregateDataSource)dsClass.newInstance();
                builder.addDataSource(new NonAggregateDataSourceWrapper(customDataSourceDefinition.getId(), source));
            }
            catch (Exception ex) {
                msgCenter.warn((Object)("Error while creating custom non aggregate data source '" + className + "'"), (Throwable)ex, new Object[0]);
                break;
            }
        }
        return builder;
    }
}

