/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.builder;

import java.util.ArrayList;
import java.util.List;
import repast.simphony.data2.DataSet;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.MethodDataSource;
import repast.simphony.data2.NonAggregateDataSet;
import repast.simphony.data2.NonAggregateDataSource;
import repast.simphony.data2.builder.AbstractDataSetBuilder;
import repast.simphony.data2.builder.DataSetBuilder;
import repast.simphony.data2.builder.SinkBuilder;

public class NonAggregateDataSetBuilder
extends AbstractDataSetBuilder
implements DataSetBuilder<NonAggregateDataSource> {
    private Class<?> targetType;
    private List<NonAggregateDataSource> dataSources = new ArrayList<NonAggregateDataSource>();

    public NonAggregateDataSetBuilder(String id, Class<?> targetType) {
        super(id);
        this.targetType = targetType;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public void addDataSource(NonAggregateDataSource dataSource) {
        if (dataSource.getId().equals("tick") && this.dataSources.size() > 0) {
            this.dataSources.add(0, dataSource);
        } else {
            this.dataSources.add(dataSource);
        }
    }

    @Override
    public DataSet create() {
        ArrayList<DataSink> sinks = new ArrayList<DataSink>();
        for (SinkBuilder sinkBuilder : this.sinkBuilders) {
            sinks.add(sinkBuilder.create(this.dataSources));
        }
        return new NonAggregateDataSet(this.id, this.dataSources, sinks);
    }

    public void defineMethodDataSource(String id, Class<?> objType, String methodName) {
        if (!this.targetType.isAssignableFrom(objType)) {
            throw new IllegalArgumentException("Invalid data source for given dataset target type.");
        }
        this.dataSources.add(new MethodDataSource(id, objType, methodName));
    }
}

