/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import repast.simphony.data2.AbstractFormatter;
import repast.simphony.data2.ConsoleDataSink;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.DataSource;
import repast.simphony.data2.FormatType;
import repast.simphony.data2.LineFormatter;
import repast.simphony.data2.TabularFormatter;
import repast.simphony.data2.builder.SinkBuilder;

public class ConsoleDataSinkBuilder
implements SinkBuilder {
    private FormatType type;
    private String delimiter;
    private ConsoleDataSink.OutputStream target;
    private Set<String> sourceIds = new LinkedHashSet<String>();

    public ConsoleDataSinkBuilder(ConsoleDataSink.OutputStream target, String delimiter, FormatType formatType) {
        this.type = formatType;
        this.delimiter = delimiter;
        this.target = target;
    }

    public void addSource(String sourceId) {
        this.sourceIds.add(sourceId);
    }

    @Override
    public DataSink create(Collection<? extends DataSource> sources) {
        ArrayList<? extends DataSource> selectedSources = new ArrayList<DataSource>();
        block0: for (String id : this.sourceIds) {
            for (DataSource dataSource : sources) {
                if (!dataSource.getId().equals(id)) continue;
                selectedSources.add(dataSource);
                continue block0;
            }
        }
        if (selectedSources.size() == 0) {
            selectedSources.addAll(sources);
        }
        AbstractFormatter formatter = this.type == FormatType.TABULAR ? new TabularFormatter(selectedSources, this.delimiter) : new LineFormatter(selectedSources, this.delimiter);
        return new ConsoleDataSink(this.target, formatter);
    }
}

