/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.data2.AggregateDSCreator;
import repast.simphony.data2.AggregateDataSet;
import repast.simphony.data2.AggregateDataSource;
import repast.simphony.data2.AggregateOp;
import repast.simphony.data2.CountDataSource;
import repast.simphony.data2.DataSet;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.MethodDataSource;
import repast.simphony.data2.builder.AbstractDataSetBuilder;
import repast.simphony.data2.builder.DataSetBuilder;
import repast.simphony.data2.builder.SinkBuilder;

public class AggregateDataSetBuilder
extends AbstractDataSetBuilder
implements DataSetBuilder<AggregateDataSource> {
    private List<AggregateDataSource> dataSources = new ArrayList<AggregateDataSource>();
    private Map<MethodDataSource, AggregateDSCreator> fmBuilderMap = new HashMap<MethodDataSource, AggregateDSCreator>();

    public AggregateDataSetBuilder(String id) {
        super(id);
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public void addDataSource(AggregateDataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    @Override
    public DataSet create() {
        ArrayList<DataSink> sinks = new ArrayList<DataSink>();
        for (SinkBuilder sinkBuilder : this.sinkBuilders) {
            sinks.add(sinkBuilder.create(this.dataSources));
        }
        return new AggregateDataSet(this.id, this.dataSources, sinks);
    }

    public void defineMethodDataSource(String id, AggregateOp aggType, Class<?> objType, String methodName) {
        MethodDataSource mds = new MethodDataSource(id, objType, methodName);
        AggregateDSCreator creator = this.fmBuilderMap.get(mds);
        if (creator == null) {
            creator = new AggregateDSCreator(mds);
            this.fmBuilderMap.put(mds, creator);
        }
        this.dataSources.add(creator.createDataSource(id, aggType));
    }

    public void defineCountDataSource(String id, Class<?> objType) {
        this.dataSources.add(new CountDataSource(id, objType));
    }
}

