/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import repast.simphony.data2.ConsoleDataSink;
import repast.simphony.data2.DataSink;
import repast.simphony.data2.FormatType;
import repast.simphony.data2.builder.ConsoleDataSinkBuilder;
import repast.simphony.data2.builder.DummySinkBuilder;
import repast.simphony.data2.builder.FileDataSinkBuilder;
import repast.simphony.data2.builder.SinkBuilder;
import repast.simphony.engine.schedule.ScheduleParameters;

public class AbstractDataSetBuilder {
    protected String id;
    private ScheduleParameters scheduleParams;
    private boolean atEnd;
    protected List<SinkBuilder> sinkBuilders = new ArrayList<SinkBuilder>();

    public AbstractDataSetBuilder(String id) {
        this.id = id;
    }

    public void defineScheduleParameters(ScheduleParameters params, boolean atEnd) {
        this.scheduleParams = params;
        this.atEnd = atEnd;
    }

    public ScheduleParameters getScheduleParameters() {
        return this.scheduleParams;
    }

    public boolean isScheduleAtEnd() {
        return this.atEnd;
    }

    public String getId() {
        return this.id;
    }

    public void addFileDataSinkBuilder(FileDataSinkBuilder builder) {
        this.sinkBuilders.add(builder);
    }

    public void defineConsoleDataSink(ConsoleDataSink.OutputStream target, String delimiter, FormatType formatType, Collection<String> sourceIds) {
        ConsoleDataSinkBuilder builder = new ConsoleDataSinkBuilder(target, delimiter, formatType);
        for (String id : sourceIds) {
            builder.addSource(id);
        }
        this.sinkBuilders.add(builder);
    }

    public void addDataSink(DataSink sink) {
        this.sinkBuilders.add(new DummySinkBuilder(sink));
    }
}

