/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import java.lang.reflect.Method;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.lang3.ClassUtils;
import repast.simphony.data2.DataException;
import repast.simphony.data2.NonAggregateDataSource;

public class MethodDataSource
implements NonAggregateDataSource {
    private static Object[] NO_ARGS = new Object[0];
    private FastMethod fmethod;
    private String id;
    private Class<?> type;
    private Class<?> sourceType;
    private int hashcode;

    public MethodDataSource(String id, Class<?> clazz, String methodName) {
        this.id = id;
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new DataException("Error creating MethodDataSource: method must not return void");
            }
            this.fmethod = FastClass.create(clazz).getMethod(method);
            this.sourceType = clazz;
            Class ret = this.fmethod.getReturnType();
            this.type = ret.isPrimitive() ? ClassUtils.primitiveToWrapper((Class)ret) : ret;
            this.hashcode = 17;
            this.hashcode = 31 * this.hashcode + id.hashCode();
            this.hashcode = 31 * this.hashcode + this.fmethod.hashCode();
            this.hashcode = 31 * this.hashcode + this.sourceType.hashCode();
            this.hashcode = 31 * this.hashcode + this.type.hashCode();
        }
        catch (Exception ex) {
            throw new DataException("Error creating MethodDataSource", ex);
        }
    }

    public FastMethod getMethod() {
        return this.fmethod;
    }

    @Override
    public Class<?> getDataType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.fmethod.invoke(obj, NO_ARGS);
        }
        catch (Exception e) {
            throw new DataException("Error invoking method on object", e);
        }
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodDataSource) {
            MethodDataSource other = (MethodDataSource)obj;
            return other.fmethod.equals((Object)this.fmethod) && other.id.equals(this.id) && other.sourceType.equals(this.sourceType) && other.type.equals(this.type);
        }
        return false;
    }
}

