/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.data2;

import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import repast.simphony.data2.AggregateDataSource;
import repast.simphony.data2.AggregateOp;
import repast.simphony.data2.CountDataSource;
import repast.simphony.data2.NonAggregateDataSource;
import simphony.util.messages.MessageCenter;

public class AggregateDSCreator {
    private NonAggregateDataSource source;
    private SummaryStatistics stats = new SummaryStatistics();

    public AggregateDSCreator(NonAggregateDataSource source) {
        this.source = source;
    }

    public AggregateDataSource createSumSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getSum();
            }
        };
    }

    public AggregateDataSource createMeanSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getMean();
            }
        };
    }

    public AggregateDataSource createMinSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getMin();
            }
        };
    }

    public AggregateDataSource createMaxSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getMax();
            }
        };
    }

    public AggregateDataSource createStdDevSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getStandardDeviation();
            }
        };
    }

    public AggregateDataSource createSumLogsSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getSumOfLogs();
            }
        };
    }

    public AggregateDataSource createSumSquaresSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getSumsq();
            }
        };
    }

    public AggregateDataSource createVarianceSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getVariance();
            }
        };
    }

    public AggregateDataSource createGeoMeanSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getGeometricMean();
            }
        };
    }

    public AggregateDataSource createSecondMomentSource(String id) {
        return new ADS(this.source, this.stats, id){

            @Override
            public Double doGet() {
                return AggregateDSCreator.this.stats.getSecondMoment();
            }
        };
    }

    public AggregateDataSource createCountSource(String id) {
        return new CountDataSource(id, this.source.getSourceType());
    }

    public AggregateDataSource createDataSource(String id, AggregateOp type) {
        switch (type) {
            case SUM: {
                return this.createSumSource(id);
            }
            case MEAN: {
                return this.createMeanSource(id);
            }
            case MIN: {
                return this.createMinSource(id);
            }
            case MAX: {
                return this.createMaxSource(id);
            }
            case COUNT: {
                return this.createCountSource(id);
            }
            case STD_DEV: {
                return this.createStdDevSource(id);
            }
            case SUM_LOGS: {
                return this.createSumLogsSource(id);
            }
            case SUM_SQRS: {
                return this.createSumSquaresSource(id);
            }
            case VARIANCE: {
                return this.createVarianceSource(id);
            }
            case GEO_MEAN: {
                return this.createGeoMeanSource(id);
            }
            case SECOND_MOMENT: {
                return this.createSecondMomentSource(id);
            }
        }
        throw new IllegalArgumentException("Unknown AggregateType '" + (Object)((Object)type) + "'.");
    }

    static abstract class ADS
    implements AggregateDataSource {
        private NonAggregateDataSource source;
        private SummaryStatistics stats = new SummaryStatistics();
        private String id;
        private Calculator calculator;

        public ADS(NonAggregateDataSource source, SummaryStatistics stats, String id) {
            Class<?> type = source.getDataType();
            this.calculator = type.equals(Boolean.class) || type.equals(Boolean.TYPE) ? new BooleanCalculator() : (type.equals(Object.class) ? new ObjectCalculator(id) : new NumberCalculator());
            this.source = source;
            this.stats = stats;
            this.id = id;
        }

        public Class<Double> getDataType() {
            return Double.class;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Object get(Iterable<?> objs, int size) {
            this.calculator.calcStats(this.source, this.stats, objs, size);
            return this.doGet();
        }

        @Override
        public void reset() {
            this.stats.clear();
        }

        public abstract Double doGet();

        @Override
        public Class<?> getSourceType() {
            return this.source.getSourceType();
        }
    }

    static class BooleanCalculator
    implements Calculator {
        BooleanCalculator() {
        }

        @Override
        public void calcStats(NonAggregateDataSource source, SummaryStatistics stats, Iterable<?> objs, int size) {
            if (stats.getN() == 0L) {
                for (Object obj : objs) {
                    boolean val = (Boolean)source.get(obj) != false;
                    stats.addValue((double)val);
                }
            }
        }
    }

    static interface Calculator {
        public void calcStats(NonAggregateDataSource var1, SummaryStatistics var2, Iterable<?> var3, int var4);
    }

    static class NumberCalculator
    implements Calculator {
        NumberCalculator() {
        }

        @Override
        public void calcStats(NonAggregateDataSource source, SummaryStatistics stats, Iterable<?> objs, int size) {
            if (stats.getN() == 0L) {
                for (Object obj : objs) {
                    stats.addValue(((Number)source.get(obj)).doubleValue());
                }
            }
        }
    }

    static class ObjectCalculator
    implements Calculator {
        private static MessageCenter msg = MessageCenter.getMessageCenter(ADS.class);
        String id;

        public ObjectCalculator(String id) {
            this.id = id;
        }

        @Override
        public void calcStats(NonAggregateDataSource source, SummaryStatistics stats, Iterable<?> objs, int size) {
            try {
                if (stats.getN() == 0L) {
                    for (Object obj : objs) {
                        stats.addValue(((Number)source.get(obj)).doubleValue());
                    }
                }
            }
            catch (ClassCastException ex) {
                msg.error((Object)("Aggregate Data Source Error: Data Source '" + this.id + "' is non-numeric"), (Throwable)ex, new Object[0]);
            }
        }
    }
}

