/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.engine.environment.ProjectionRegistry;
import repast.simphony.engine.environment.ProjectionRegistryData;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.AmountConverter;
import repast.simphony.xml.ContinuousValueLayerConverter;
import repast.simphony.xml.DefaultContextConverter;
import repast.simphony.xml.GridConverter;
import repast.simphony.xml.GridValueLayerConverter;
import repast.simphony.xml.NetworkConverter;
import repast.simphony.xml.SpaceConverter;

public class XMLSerializer {
    private List<Converter> nonDefaultConverter = new ArrayList<Converter>();
    private XStream xstream = new XStream();

    public XMLSerializer() {
        this.xstream.registerConverter((Converter)new DefaultContextConverter());
        this.xstream.registerConverter((Converter)new NetworkConverter());
        this.xstream.registerConverter((Converter)new GridConverter());
        this.xstream.registerConverter((Converter)new SpaceConverter());
        this.xstream.registerConverter((Converter)new RootConverter());
        this.xstream.registerConverter((Converter)new AmountConverter());
        this.xstream.registerConverter((Converter)new GridValueLayerConverter());
        this.xstream.registerConverter((Converter)new ContinuousValueLayerConverter());
        for (ProjectionRegistryData data : ProjectionRegistry.getRegistryData()) {
            this.xstream.registerConverter((Converter)data.getProjectionXMLConverter());
        }
        this.xstream.alias("root", Root.class);
        this.xstream.setMode(1004);
    }

    public void registerConverter(Converter converter) {
        this.nonDefaultConverter.add(converter);
        this.xstream.registerConverter(converter);
    }

    public String toXML(Object obj) {
        StringWriter writer = new StringWriter();
        this.toXML(obj, writer);
        return writer.toString();
    }

    public void toXML(Object obj, Writer writer) {
        Root root = new Root();
        root.obj = obj;
        this.xstream.toXML((Object)root, writer);
    }

    public void toXML(Object obj, OutputStream stream) {
        Root root = new Root();
        root.obj = obj;
        this.xstream.toXML((Object)root, stream);
    }

    public Object fromXML(InputStream input) {
        return this.xstream.fromXML(input);
    }

    public Object fromXML(Reader reader) {
        return this.xstream.fromXML(reader);
    }

    public Object fromXML(String xml) {
        return this.xstream.fromXML(xml);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.xstream.setClassLoader(classLoader);
    }

    private class Root {
        private Object obj;

        private Root() {
        }
    }

    private class RootConverter
    extends AbstractConverter {
        private RootConverter() {
        }

        public boolean canConvert(Class aClass) {
            return aClass.equals(Root.class);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
            try {
                int count = Integer.valueOf(this.readNextString(reader));
                int i = 0;
                while (i < count) {
                    Class<?> clazz = Class.forName(this.readNextString(reader));
                    Converter converter = (Converter)clazz.newInstance();
                    XMLSerializer.this.xstream.registerConverter(converter);
                    ++i;
                }
                return this.readNextObject(null, reader, umContext);
            }
            catch (ClassNotFoundException e) {
                throw new XStreamException("Error while reading converters", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new XStreamException("Error while reading converters", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new XStreamException("Error while reading converters", (Throwable)e);
            }
        }

        public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mContext) {
            Root root = (Root)o;
            this.writeString("converter_count", String.valueOf(XMLSerializer.this.nonDefaultConverter.size()), writer);
            for (Converter converter : XMLSerializer.this.nonDefaultConverter) {
                this.writeString("converter_class", converter.getClass().getName(), writer);
            }
            this.writeObject("root_obj", root.obj, writer, mContext);
        }
    }
}

