/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import repast.simphony.context.Context;
import repast.simphony.context.space.continuous.ContextSpace;
import repast.simphony.context.space.continuous.ContinuousSpaceFactoryFinder;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.util.collections.Pair;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.Keys;

public class SpaceConverter
extends AbstractConverter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(ContextSpace.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        ContinuousSpace space = (ContinuousSpace)o;
        this.writeString("name", space.getName(), writer);
        this.writeString("adder", space.getAdder().getClass().getName(), writer);
        this.writeString("translator", space.getPointTranslator().getClass().getName(), writer);
        double[] dims = space.getDimensions().toDoubleArray(null);
        this.writeString("dims", this.arrayToString(dims), writer);
        double[] origin = space.getDimensions().originToDoubleArray(null);
        this.writeString("origin", this.arrayToString(origin), writer);
        this.writeString("item_count", String.valueOf(space.size()), writer);
        for (Object obj : space.getObjects()) {
            NdPoint point = space.getLocation(obj);
            Pair p = new Pair(obj, point);
            this.writeObject("space_entry", p, writer, mContext);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
        try {
            Context context = (Context)umContext.get((Object)Keys.CONTEXT);
            String name = this.readNextString(reader);
            String adder = this.readNextString(reader);
            Class<?> adderClass = Class.forName(adder);
            ContinuousAdder cAdder = (ContinuousAdder)adderClass.newInstance();
            Class<?> transClass = Class.forName(this.readNextString(reader));
            PointTranslator trans = (PointTranslator)transClass.newInstance();
            double[] dims = this.stringToDblArray(this.readNextString(reader));
            double[] origin = this.stringToDblArray(this.readNextString(reader));
            ContinuousSpace space = ContinuousSpaceFactoryFinder.createContinuousSpaceFactory(null).createContinuousSpace(name, context, cAdder, trans, dims, origin);
            int itemCount = Integer.valueOf(this.readNextString(reader));
            int i = 0;
            while (i < itemCount) {
                Pair pair = (Pair)this.readNextObject(space, reader, umContext);
                NdPoint point = (NdPoint)pair.getSecond();
                if (point != null) {
                    if (!context.contains(pair.getFirst())) {
                        context.add(pair.getFirst());
                    }
                    space.moveTo(pair.getFirst(), point.toDoubleArray(null));
                }
                ++i;
            }
            return space;
        }
        catch (Exception ex) {
            throw new ConversionException("Error deserializing ContinuousSpace", (Throwable)ex);
        }
    }
}

