/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import repast.simphony.context.Context;
import repast.simphony.context.space.graph.ContextJungNetwork;
import repast.simphony.context.space.graph.NetworkFactoryFinder;
import repast.simphony.space.graph.EdgeCreator;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.DelegatingEdgeCreator;
import repast.simphony.xml.Keys;

public class NetworkConverter
extends AbstractConverter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(ContextJungNetwork.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        Network network = (Network)o;
        this.writeString("name", network.getName(), writer);
        this.writeString("isDirected", String.valueOf(network.isDirected()), writer);
        this.writeObject("edgeCreator", network.getEdgeCreator(), writer, mContext);
        this.writeString("edgeCount", String.valueOf(network.getDegree()), writer);
        for (RepastEdge edge : network.getEdges()) {
            this.writeObject("edge", edge, writer, mContext);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
        try {
            Context context = (Context)umContext.get((Object)Keys.CONTEXT);
            String name = this.readNextString(reader);
            boolean isDirected = Boolean.parseBoolean(this.readNextString(reader));
            DelegatingEdgeCreator creator = new DelegatingEdgeCreator();
            Network network = NetworkFactoryFinder.createNetworkFactory(null).createNetwork(name, context, isDirected, creator);
            creator.initDelegate((EdgeCreator)this.readNextObject(network, reader, umContext));
            int edgeCount = Integer.valueOf(this.readNextString(reader));
            int i = 0;
            while (i < edgeCount) {
                RepastEdge edge = (RepastEdge)this.readNextObject(network, reader, umContext);
                if (!context.contains(edge.getSource())) {
                    context.add(edge.getSource());
                }
                if (!context.contains(edge.getTarget())) {
                    context.add(edge.getTarget());
                }
                network.addEdge(edge);
                ++i;
            }
            return network;
        }
        catch (Exception ex) {
            throw new ConversionException("Error reading Network", (Throwable)ex);
        }
    }
}

