/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import repast.simphony.context.Context;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.util.collections.Pair;
import repast.simphony.valueLayer.GridValueLayer;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.Keys;

public class GridValueLayerConverter
extends AbstractConverter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(GridValueLayer.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        try {
            GridValueLayer grid = (GridValueLayer)o;
            Field field = GridValueLayer.class.getDeclaredField("dense");
            field.setAccessible(true);
            Boolean dense = (Boolean)field.get(grid);
            this.writeString("name", grid.getName(), writer);
            this.writeString("dense", dense.toString(), writer);
            this.writeString("translator", grid.getGridPointTranslator().getClass().getName(), writer);
            int[] dims = grid.getDimensions().toIntArray(null);
            this.writeString("dims", this.arrayToString(dims), writer);
            int[] origin = grid.getDimensions().originToIntArray(null);
            this.writeString("origin", this.arrayToString(origin), writer);
            int[] pt = new int[dims.length];
            pt[dims.length - 1] = -1;
            int count = 1;
            int[] nArray = dims;
            int n = dims.length;
            int n2 = 0;
            while (n2 < n) {
                int val = nArray[n2];
                count *= val;
                ++n2;
            }
            this.writeString("item_count", String.valueOf(count), writer);
            int i = 0;
            while (i < count) {
                this.nextPoint(dims, pt);
                int[] actualPt = new int[pt.length];
                double[] actualPtD = new double[pt.length];
                int j = 0;
                while (j < pt.length) {
                    actualPt[j] = pt[j] - origin[j];
                    actualPtD[j] = actualPt[j];
                    ++j;
                }
                Pair<int[], Double> p = new Pair<int[], Double>(actualPt, grid.get(actualPtD));
                this.writeObject("grid_entry", p, writer, mContext);
                ++i;
            }
        }
        catch (Exception ex) {
            throw new XStreamException("Error while writing GridValueLayer", (Throwable)ex);
        }
    }

    private void nextPoint(int[] dims, int[] pt) {
        int index = dims.length - 1;
        int val = pt[index] + 1;
        while (val >= dims[index]) {
            pt[index] = 0;
            if (index == 0) {
                val = 0;
                break;
            }
            val = pt[--index] + 1;
        }
        pt[index] = val;
    }

    public static void main(String[] args) {
        GridValueLayerConverter con = new GridValueLayerConverter();
        int[] dims = new int[]{2, 2, 3};
        int[] nArray = new int[3];
        nArray[2] = -1;
        int[] pt = nArray;
        int i = 0;
        while (i < 12) {
            con.nextPoint(dims, pt);
            System.out.println("pt = " + Arrays.toString(pt));
            ++i;
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
        try {
            Context context = (Context)umContext.get((Object)Keys.CONTEXT);
            String name = this.readNextString(reader);
            String strDense = this.readNextString(reader);
            boolean dense = Boolean.valueOf(strDense);
            Class<?> transClass = Class.forName(this.readNextString(reader));
            GridPointTranslator trans = (GridPointTranslator)transClass.newInstance();
            int[] dims = this.stringToIntArray(this.readNextString(reader));
            int[] origin = this.stringToIntArray(this.readNextString(reader));
            GridValueLayer grid = new GridValueLayer(name, 0.0, dense, trans, dims, origin);
            context.addValueLayer(grid);
            int itemCount = Integer.valueOf(this.readNextString(reader));
            int i = 0;
            while (i < itemCount) {
                Pair pair = (Pair)this.readNextObject(grid, reader, umContext);
                int[] pt = (int[])pair.getFirst();
                double val = (Double)pair.getSecond();
                grid.set(val, pt);
                ++i;
            }
            return grid;
        }
        catch (Exception ex) {
            throw new ConversionException("Error deserializing GridValueLayer", (Throwable)ex);
        }
    }
}

