/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import repast.simphony.context.Context;
import repast.simphony.context.space.grid.ContextGrid;
import repast.simphony.context.space.grid.GridFactoryFinder;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridBuilderParameters;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.util.collections.Pair;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.Keys;

public class GridConverter
extends AbstractConverter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(ContextGrid.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        Grid grid = (Grid)o;
        this.writeString("name", grid.getName(), writer);
        this.writeString("adder", grid.getAdder().getClass().getName(), writer);
        this.writeString("translator", grid.getGridPointTranslator().getClass().getName(), writer);
        int[] dims = grid.getDimensions().toIntArray(null);
        this.writeString("dims", this.arrayToString(dims), writer);
        int[] origin = grid.getDimensions().originToIntArray(null);
        this.writeString("origin", this.arrayToString(origin), writer);
        this.writeString("multi", String.valueOf(grid.getCellAccessor().allowsMultiOccupancy()), writer);
        this.writeString("item_count", String.valueOf(grid.size()), writer);
        for (Object obj : grid.getObjects()) {
            GridPoint point = grid.getLocation(obj);
            Pair p = new Pair(obj, point);
            this.writeObject("grid_entry", p, writer, mContext);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
        try {
            Context context = (Context)umContext.get((Object)Keys.CONTEXT);
            String name = this.readNextString(reader);
            String adder = this.readNextString(reader);
            Class<?> adderClass = Class.forName(adder);
            GridAdder gAdder = (GridAdder)adderClass.newInstance();
            Class<?> transClass = Class.forName(this.readNextString(reader));
            GridPointTranslator trans = (GridPointTranslator)transClass.newInstance();
            int[] dims = this.stringToIntArray(this.readNextString(reader));
            int[] origin = this.stringToIntArray(this.readNextString(reader));
            boolean multi = Boolean.valueOf(this.readNextString(reader));
            GridBuilderParameters params = new GridBuilderParameters(trans, gAdder, multi, dims, origin);
            Grid grid = GridFactoryFinder.createGridFactory(null).createGrid(name, context, params);
            int itemCount = Integer.valueOf(this.readNextString(reader));
            int i = 0;
            while (i < itemCount) {
                Pair pair = (Pair)this.readNextObject(grid, reader, umContext);
                GridPoint point = (GridPoint)pair.getSecond();
                if (point != null) {
                    if (!context.contains(pair.getFirst())) {
                        context.add(pair.getFirst());
                    }
                    grid.moveTo(pair.getFirst(), point.toIntArray(null));
                }
                ++i;
            }
            return grid;
        }
        catch (Exception ex) {
            throw new ConversionException("Error deserializing Grid", (Throwable)ex);
        }
    }
}

