/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.space.projection.Projection;
import repast.simphony.valueLayer.ValueLayer;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.Keys;

public class DefaultContextConverter
extends AbstractConverter
implements Converter {
    public boolean canConvert(Class aClass) {
        return DefaultContext.class.isAssignableFrom(aClass);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        try {
            DefaultContext context = (DefaultContext)obj;
            Field field = DefaultContext.class.getDeclaredField("contents");
            field.setAccessible(true);
            Collection items = (Collection)field.get(context);
            this.writeObject("id", context.getId(), writer, mContext);
            this.writeObject("type_id", context.getTypeID(), writer, mContext);
            this.writeString("size", String.valueOf(items.size()), writer);
            for (Object item : items) {
                this.writeObject("agent", item, writer, mContext);
            }
            ArrayList<Context> subs = new ArrayList<Context>();
            for (Context sub : context.getSubContexts()) {
                subs.add(sub);
            }
            this.writeString("sub_count", String.valueOf(subs.size()), writer);
            for (Context sub : subs) {
                this.writeObject("sub_context", sub, writer, mContext);
            }
            this.writeString("proj_count", String.valueOf(context.getProjections().size()), writer);
            ArrayList projs = new ArrayList(context.getProjections());
            for (Projection projection : projs) {
                this.writeObject("projection", projection, writer, mContext);
            }
            this.writeString("vl_count", String.valueOf(context.getValueLayers().size()), writer);
            for (ValueLayer valueLayer : context.getValueLayers()) {
                this.writeObject("vl", valueLayer, writer, mContext);
            }
        }
        catch (Exception ex) {
            throw new XStreamException("Error while writing context", (Throwable)ex);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
        DefaultContext<Object> context = new DefaultContext<Object>();
        try {
            Object id = this.readNextObject(context, reader, umContext);
            context.setId(id);
            Object typeID = this.readNextObject(context, reader, umContext);
            context.setTypeID(typeID);
            umContext.put((Object)Keys.CONTEXT, context);
            int size = Integer.parseInt(this.readNextString(reader));
            int i = 0;
            while (i < size) {
                context.add(this.readNextObject(context, reader, umContext));
                ++i;
            }
            int cCount = Integer.parseInt(this.readNextString(reader));
            int i2 = 0;
            while (i2 < cCount) {
                Context sub = (Context)this.readNextObject(context, reader, umContext);
                context.addSubContext(sub);
                ++i2;
            }
            int pCount = Integer.parseInt(this.readNextString(reader));
            umContext.put((Object)Keys.CONTEXT, context);
            int i3 = 0;
            while (i3 < pCount) {
                this.readNextObject(context, reader, umContext);
                ++i3;
            }
            int vlCount = Integer.parseInt(this.readNextString(reader));
            umContext.put((Object)Keys.CONTEXT, context);
            int i4 = 0;
            while (i4 < vlCount) {
                this.readNextObject(context, reader, umContext);
                ++i4;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ConversionException("Error while deserializing context", (Throwable)ex);
        }
        return context;
    }
}

