/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;
import java.util.Map;
import repast.simphony.context.Context;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.util.collections.Pair;
import repast.simphony.valueLayer.ContinuousValueLayer;
import repast.simphony.xml.AbstractConverter;
import repast.simphony.xml.Keys;

public class ContinuousValueLayerConverter
extends AbstractConverter {
    public boolean canConvert(Class aClass) {
        return aClass.equals(ContinuousValueLayer.class);
    }

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        try {
            ContinuousValueLayer layer = (ContinuousValueLayer)o;
            Field field = ContinuousValueLayer.class.getDeclaredField("defaultValue");
            field.setAccessible(true);
            double defVal = (Double)field.get(layer);
            this.writeString("name", layer.getName(), writer);
            this.writeString("defaultValue", String.valueOf(defVal), writer);
            double[] dims = layer.getDimensions().toDoubleArray(null);
            this.writeString("dims", this.arrayToString(dims), writer);
            field = ContinuousValueLayer.class.getDeclaredField("locationMap");
            field.setAccessible(true);
            Map map = (Map)field.get(layer);
            this.writeString("item_count", String.valueOf(map.size()), writer);
            for (NdPoint pt : map.keySet()) {
                Double val = (Double)map.get(pt);
                Pair<NdPoint, Double> p = new Pair<NdPoint, Double>(pt, val);
                this.writeObject("item", p, writer, mContext);
            }
        }
        catch (Exception ex) {
            throw new XStreamException("Error while writing ContinuousValueLayer", (Throwable)ex);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext umContext) {
        try {
            Context context = (Context)umContext.get((Object)Keys.CONTEXT);
            String name = this.readNextString(reader);
            String strVal = this.readNextString(reader);
            double defVal = Double.parseDouble(strVal);
            double[] dims = this.stringToDblArray(this.readNextString(reader));
            ContinuousValueLayer layer = new ContinuousValueLayer(name, defVal, true, dims);
            context.addValueLayer(layer);
            int itemCount = Integer.valueOf(this.readNextString(reader));
            int i = 0;
            while (i < itemCount) {
                Pair pair = (Pair)this.readNextObject(layer, reader, umContext);
                NdPoint pt = (NdPoint)pair.getFirst();
                double val = (Double)pair.getSecond();
                layer.set(val, pt.toDoubleArray(null));
                ++i;
            }
            return layer;
        }
        catch (Exception ex) {
            throw new ConversionException("Error deserializing continuous value layer", (Throwable)ex);
        }
    }
}

