/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractConverter
implements Converter {
    protected Map<String, Class<?>> classMap = new HashMap();

    protected String arrayToString(double[] vals) {
        StringBuilder buf = new StringBuilder();
        double[] dArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            buf.append(val);
            buf.append(" ");
            ++n2;
        }
        return buf.toString().trim();
    }

    protected double[] stringToDblArray(String val) {
        String[] vals = val.split(" ");
        double[] ret = new double[vals.length];
        int i = 0;
        while (i < vals.length) {
            ret[i] = Double.parseDouble(vals[i]);
            ++i;
        }
        return ret;
    }

    protected String arrayToString(int[] vals) {
        StringBuilder buf = new StringBuilder();
        int[] nArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            buf.append(val);
            buf.append(" ");
            ++n2;
        }
        return buf.toString().trim();
    }

    protected int[] stringToIntArray(String val) {
        String[] vals = val.split(" ");
        int[] ret = new int[vals.length];
        int i = 0;
        while (i < vals.length) {
            ret[i] = Integer.parseInt(vals[i]);
            ++i;
        }
        return ret;
    }

    protected Object readNextObject(Object parent, HierarchicalStreamReader reader, UnmarshallingContext umContext) throws ClassNotFoundException {
        reader.moveDown();
        Object obj = umContext.convertAnother(parent, this.findClass(reader));
        reader.moveUp();
        return obj;
    }

    protected String readNextString(HierarchicalStreamReader reader) {
        reader.moveDown();
        String val = reader.getValue();
        reader.moveUp();
        return val;
    }

    private Class<?> findClass(HierarchicalStreamReader reader) throws ClassNotFoundException {
        String name = reader.getAttribute("class");
        Class<?> clazz = this.classMap.get(name);
        if (clazz == null) {
            clazz = Class.forName(name);
            this.classMap.put(name, clazz);
        }
        return clazz;
    }

    protected void writeObject(String nodeName, Object obj, HierarchicalStreamWriter writer, MarshallingContext mContext) {
        writer.startNode(nodeName);
        writer.addAttribute("class", obj.getClass().getName());
        mContext.convertAnother(obj);
        writer.endNode();
    }

    protected void writeString(String nodeName, String value, HierarchicalStreamWriter writer) {
        writer.startNode(nodeName);
        writer.setValue(value);
        writer.endNode();
    }
}

