/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.valueLayer;

import repast.simphony.space.continuous.WrapAroundBorders;
import repast.simphony.valueLayer.IGridValueLayer;
import repast.simphony.valueLayer.ValueLayer;

public class ValueLayerDiffuser {
    public static final double DEFAULT_MAX = 32767.0;
    public static final double DEFAULT_MIN = -32767.0;
    public static final double DEFAULT_EVAP_CONST = 1.0;
    public static final double DEFAULT_DIFF_CONST = 1.0;
    private static final long serialVersionUID = 1L;
    private static final double OUT_OF_BOUNDS = 0.0;
    protected IGridValueLayer valueLayer;
    protected double maxValue = 32767.0;
    protected double minValue = -32767.0;
    protected double evaporationConst;
    protected double diffusionConst;
    protected boolean toroidal;
    protected transient Object computedVals;
    private transient WrapAroundBorders borders;

    public ValueLayerDiffuser() {
        this(null, 1.0, 1.0);
    }

    public ValueLayerDiffuser(IGridValueLayer valueLayer, double evaporationConst, double diffusionConst) {
        this(valueLayer, evaporationConst, diffusionConst, true);
    }

    public ValueLayerDiffuser(IGridValueLayer valueLayer, double evaporationConst, double diffusionConst, boolean toroidal) {
        this.evaporationConst = evaporationConst;
        this.diffusionConst = diffusionConst;
        this.toroidal = toroidal;
        this.setValueLayer(valueLayer);
    }

    protected double getValue(double ... coords) {
        if (this.toroidal) {
            if (this.borders == null) {
                this.borders = new WrapAroundBorders();
                this.borders.init(this.valueLayer.getDimensions());
            }
            this.borders.transform(coords, coords);
        } else if (this.inBounds(coords) == 0.0) {
            return 0.0;
        }
        return this.valueLayer.get(coords);
    }

    protected double inBounds(double ... coords) {
        if (this.toroidal) {
            return 1.0;
        }
        int i = 0;
        while (i < coords.length) {
            if (coords[i] < 0.0 || coords[i] > this.valueLayer.getDimensions().getDimension(i) - 1.0) {
                return 0.0;
            }
            ++i;
        }
        return 1.0;
    }

    protected double constrainByMinMax(double val) {
        if (val > this.maxValue) {
            return this.maxValue;
        }
        if (val < this.minValue) {
            return this.minValue;
        }
        return val;
    }

    protected void computeVals() {
        int size = this.valueLayer.getDimensions().size();
        if (size == 1) {
            int width = (int)this.valueLayer.getDimensions().getWidth();
            double[] newVals = new double[width];
            int x = 0;
            while (x < width) {
                double sum = this.getValue(x - 1);
                double weightedAvg = (sum += this.getValue(x + 1)) / 2.0;
                double oldVal = this.getValue(x);
                double delta = weightedAvg - oldVal;
                double newVal = (oldVal + delta * this.diffusionConst) * this.evaporationConst;
                newVals[x] = this.constrainByMinMax(newVal);
                ++x;
            }
            this.computedVals = newVals;
        } else if (size == 2) {
            int width = (int)this.valueLayer.getDimensions().getWidth();
            int height = (int)this.valueLayer.getDimensions().getHeight();
            double[][] newVals = new double[width][height];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    double uE = this.getValue(x + 1, y);
                    double uN = this.getValue(x, y + 1);
                    double uW = this.getValue(x - 1, y);
                    double uS = this.getValue(x, y - 1);
                    double uNE = this.getValue(x + 1, y + 1);
                    double uNW = this.getValue(x - 1, y + 1);
                    double uSW = this.getValue(x - 1, y - 1);
                    double uSE = this.getValue(x + 1, y - 1);
                    double weightedAvg = ((uE + uN + uW + uS) * 4.0 + (uNE + uNW + uSW + uSE)) / 20.0;
                    double oldVal = this.getValue(x, y);
                    double delta = weightedAvg - oldVal;
                    double newVal = (oldVal + delta * this.diffusionConst) * this.evaporationConst;
                    newVals[x][y] = this.constrainByMinMax(newVal);
                    ++x;
                }
                ++y;
            }
            this.computedVals = newVals;
        } else if (size == 3) {
            int width = (int)this.valueLayer.getDimensions().getWidth();
            int height = (int)this.valueLayer.getDimensions().getHeight();
            int depth = (int)this.valueLayer.getDimensions().getDepth();
            double[][][] newVals = new double[width][height][depth];
            int z = 0;
            while (z < depth) {
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        newVals[x][y][z] = this.compute3dVal(x, y, z);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            this.computedVals = newVals;
        }
    }

    private double compute3dVal(double xCoord, double yCoord, double zCoord) {
        double weightedSum = 0.0;
        int numberEqual = 0;
        double multiplier = 1.0;
        int count = 0;
        double z = zCoord - 1.0;
        while (z <= zCoord + 1.0) {
            double y = yCoord - 1.0;
            while (y <= yCoord + 1.0) {
                double x = xCoord - 1.0;
                while (x <= xCoord + 1.0) {
                    numberEqual = 0;
                    if (xCoord == x) {
                        ++numberEqual;
                    }
                    if (yCoord == y) {
                        ++numberEqual;
                    }
                    if (zCoord == z) {
                        ++numberEqual;
                    }
                    if (numberEqual != 3) {
                        multiplier = numberEqual == 2 ? 4.0 : 1.0;
                        weightedSum += multiplier * this.getValue(x, y, z);
                        count = (int)((double)count + multiplier);
                    }
                    x += 1.0;
                }
                y += 1.0;
            }
            z += 1.0;
        }
        double weightedAvg = weightedSum / (double)count;
        double oldVal = this.getValue(xCoord, yCoord, zCoord);
        double delta = weightedAvg - oldVal;
        return this.constrainByMinMax((oldVal + delta * this.diffusionConst) * this.evaporationConst);
    }

    public void diffuse() {
        this.computeVals();
        int size = this.valueLayer.getDimensions().size();
        if (size == 1) {
            double[] newVals = (double[])this.computedVals;
            int x = 0;
            while (x < newVals.length) {
                this.valueLayer.set(newVals[x], x);
                ++x;
            }
        } else if (size == 2) {
            double[][] newVals = (double[][])this.computedVals;
            int x = 0;
            while (x < newVals.length) {
                int y = 0;
                while (y < newVals[0].length) {
                    this.valueLayer.set(newVals[x][y], x, y);
                    ++y;
                }
                ++x;
            }
        } else {
            double[][][] newVals = (double[][][])this.computedVals;
            int x = 0;
            while (x < newVals[0].length) {
                int y = 0;
                while (y < newVals[0][0].length) {
                    int z = 0;
                    while (z < newVals.length) {
                        this.valueLayer.set(newVals[x][y][z], x, y, z);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public double getDiffusionConst() {
        return this.diffusionConst;
    }

    public void setDiffusionConst(double diffusionConst) {
        this.diffusionConst = diffusionConst;
    }

    public double getEvaporationConst() {
        return this.evaporationConst;
    }

    public void setEvaporationConst(double evapRate) {
        this.evaporationConst = evapRate;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double max) {
        this.maxValue = max;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double min) {
        this.minValue = min;
    }

    public boolean isToroidal() {
        return this.toroidal;
    }

    public void setToroidal(boolean toroidal) {
        this.toroidal = toroidal;
    }

    public ValueLayer getValueLayer() {
        return this.valueLayer;
    }

    public void setValueLayer(IGridValueLayer valueLayer) {
        if (valueLayer.getDimensions().size() > 3) {
            throw new RuntimeException("Value layer diffuser only works for 1d, 2d or 3d value layers.");
        }
        this.valueLayer = valueLayer;
    }
}

