/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.valueLayer;

import repast.simphony.space.Dimensions;
import repast.simphony.space.SpatialException;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.grid.StrictBorders;
import repast.simphony.valueLayer.DenseValueLayerStore;
import repast.simphony.valueLayer.GridFunction;
import repast.simphony.valueLayer.IGridValueLayer;
import repast.simphony.valueLayer.SparseValueLayerStore;
import repast.simphony.valueLayer.ValueLayerStore;
import simphony.util.messages.MessageCenter;

public class GridValueLayer
implements IGridValueLayer {
    protected String name;
    protected ValueLayerStore store;
    protected int[] stride;
    protected Dimensions dims;
    protected int[] origin;
    protected boolean dense;
    protected GridPointTranslator translator;

    public GridValueLayer(String name, boolean dense, int ... dimensions) {
        this(name, 0.0, dense, dimensions);
    }

    public GridValueLayer(String name, double defaultValue, boolean dense, int ... dimensions) {
        this(name, defaultValue, dense, (GridPointTranslator)new StrictBorders(), dimensions);
    }

    public GridValueLayer(String name, boolean dense, GridPointTranslator translator, int ... dimensions) {
        this(name, 0.0, dense, translator, dimensions);
    }

    public GridValueLayer(String name, double defaultValue, boolean dense, GridPointTranslator translator, int ... dimensions) {
        this(name, defaultValue, dense, translator, dimensions, new int[dimensions.length]);
    }

    public GridValueLayer(String name, double defaultValue, boolean dense, GridPointTranslator translator, int[] dimensions, int[] origin) {
        this.name = name;
        this.dense = dense;
        this.translator = translator;
        long _size = 1L;
        int[] nArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int dim = nArray[n2];
            _size *= (long)dim;
            ++n2;
        }
        if (dense) {
            if (_size > Integer.MAX_VALUE) {
                SpatialException ex = new SpatialException("Dense grid value layer capacity exceded: " + _size + ". Try sparse value layer.");
                MessageCenter.getMessageCenter(GridValueLayer.class).error((Object)"Value layer initialization error: ", (Throwable)ex, new Object[0]);
                throw ex;
            }
            this.store = new DenseValueLayerStore((int)_size, defaultValue);
        } else {
            this.store = new SparseValueLayerStore((int)_size, defaultValue);
        }
        int tmpStride = 1;
        this.stride = new int[dimensions.length];
        int i = dimensions.length - 1;
        while (i >= 0) {
            this.stride[i] = tmpStride;
            tmpStride *= dimensions[i];
            --i;
        }
        translator.init(new GridDimensions(dimensions, origin));
        this.dims = new Dimensions(dimensions, origin);
        this.origin = origin;
    }

    public void forEach(GridFunction function, GridPoint origin, int ... extent) {
        int y;
        int x;
        int i;
        int dimsSize = this.dims.size();
        if (extent.length != dimsSize) {
            throw new IllegalArgumentException("Number of extents must be equal to the number of grid dimensions.");
        }
        if (dimsSize > 3 || dimsSize < 1) {
            throw new IllegalArgumentException("forEach is only supported on 1D, 2D and 3D GridValueLayers");
        }
        int[] mins = new int[dimsSize];
        int[] maxs = new int[dimsSize];
        if (this.translator.isToroidal()) {
            i = 0;
            while (i < dimsSize) {
                mins[i] = origin.getCoord(i) - extent[i];
                maxs[i] = origin.getCoord(i) + extent[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < dimsSize) {
                int min = origin.getCoord(i) - extent[i];
                if ((double)min < this.dims.getOrigin(i)) {
                    min = (int)this.dims.getOrigin(i);
                }
                mins[i] = min;
                int max = origin.getCoord(i) + extent[i];
                if ((double)max >= this.dims.getOrigin(i) + this.dims.getDimension(i)) {
                    max = (int)(this.dims.getOrigin(i) + this.dims.getDimension(i)) - 1;
                }
                maxs[i] = max;
                ++i;
            }
        }
        if (dimsSize == 1) {
            x = mins[0];
            while (x <= maxs[0]) {
                function.apply(this.get(x), x++);
            }
        } else if (dimsSize == 2) {
            x = mins[0];
            while (x <= maxs[0]) {
                y = mins[1];
                while (y <= maxs[1]) {
                    function.apply(this.get(x, y), x, y++);
                }
                ++x;
            }
        } else {
            x = mins[0];
            while (x <= maxs[0]) {
                y = mins[1];
                while (y <= maxs[1]) {
                    int z = mins[2];
                    while (z <= maxs[2]) {
                        function.apply(this.get(x, y, z), x, y, z++);
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    @Override
    public double get(double ... coordinates) {
        int[] coords = new int[coordinates.length];
        int i = 0;
        while (i < coordinates.length) {
            coords[i] = (int)coordinates[i];
            ++i;
        }
        int index = this.getIndex(this.getTransformedLocation(coords));
        return this.store.get(index);
    }

    private int getIndex(int ... point) {
        int[] matrixPoint = new int[point.length];
        int i = 0;
        while (i < point.length) {
            matrixPoint[i] = point[i] + this.origin[i];
            ++i;
        }
        int index = 0;
        int i2 = 0;
        while (i2 < matrixPoint.length) {
            index += matrixPoint[i2] * this.stride[i2];
            ++i2;
        }
        return index;
    }

    @Override
    public void set(double value, int ... coordinate) {
        if (coordinate.length != this.dims.size()) {
            throw new SpatialException("Invalid number coordinates");
        }
        int index = this.getIndex(this.getTransformedLocation(coordinate));
        this.store.set(index, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Dimensions getDimensions() {
        return this.dims;
    }

    protected int[] getTransformedLocation(int ... location) {
        int[] loc = new int[location.length];
        this.translator.transform(loc, location);
        return loc;
    }

    public GridPointTranslator getGridPointTranslator() {
        return this.translator;
    }

    public void setGridPointTranslator(GridPointTranslator rule) {
        this.translator = rule;
    }

    public int size() {
        return this.store.size();
    }
}

