/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.valueLayer;

import java.util.HashMap;
import java.util.Map;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.NdPoint;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.continuous.StrictBorders;
import repast.simphony.valueLayer.ValueLayer;

public class ContinuousValueLayer
implements ValueLayer {
    protected String name;
    protected Dimensions dims;
    protected double defaultValue;
    protected Map<NdPoint, Double> locationMap;
    protected boolean dense;
    protected PointTranslator translator;

    public ContinuousValueLayer(String name, double ... dimensions) {
        this(name, 0.0, true, dimensions);
    }

    public ContinuousValueLayer(String name, boolean dense, double ... dimensions) {
        this(name, 0.0, dense, dimensions);
    }

    public ContinuousValueLayer(String name, double defaultValue, boolean dense, double ... dimensions) {
        this(name, defaultValue, dense, new StrictBorders(), dimensions);
    }

    public ContinuousValueLayer(String name, boolean dense, PointTranslator translator, double ... dimensions) {
        this(name, 0.0, dense, translator, dimensions);
    }

    public ContinuousValueLayer(String name, double defaultVal, boolean dense, PointTranslator translator, double ... dimensions) {
        this.name = name;
        this.defaultValue = defaultVal;
        this.dense = dense;
        this.translator = translator;
        this.dims = new Dimensions(dimensions);
        this.locationMap = new HashMap<NdPoint, Double>();
        translator.init(this.dims);
    }

    @Override
    public double get(double ... coordinates) {
        NdPoint point = new NdPoint(coordinates);
        Double value = this.locationMap.get(point);
        return value == null ? this.defaultValue : value;
    }

    public void set(double value, double ... coordinate) {
        NdPoint point = new NdPoint(coordinate);
        this.locationMap.put(point, value);
    }

    protected double[] getLocation(double ... location) {
        double[] loc = new double[location.length];
        this.translator.transform(loc, location);
        return loc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Dimensions getDimensions() {
        return this.dims;
    }

    public PointTranslator getPointTranslator() {
        return this.translator;
    }

    public void setPointTranslator(PointTranslator rule) {
        this.translator = rule;
    }
}

