/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.valueLayer;

import repast.simphony.space.Dimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.grid.StrictBorders;
import repast.simphony.valueLayer.GridFunction;
import repast.simphony.valueLayer.GridValueLayer;
import repast.simphony.valueLayer.IGridValueLayer;

public class BufferedGridValueLayer
implements IGridValueLayer {
    private GridValueLayer read;
    private GridValueLayer write;

    public BufferedGridValueLayer(String name, boolean dense, int ... dimensions) {
        this(name, 0.0, dense, dimensions);
    }

    public BufferedGridValueLayer(String name, double defaultValue, boolean dense, int ... dimensions) {
        this(name, defaultValue, dense, (GridPointTranslator)new StrictBorders(), dimensions);
    }

    public BufferedGridValueLayer(String name, boolean dense, GridPointTranslator translator, int ... dimensions) {
        this(name, 0.0, dense, translator, dimensions);
    }

    public BufferedGridValueLayer(String name, double defaultValue, boolean dense, GridPointTranslator translator, int ... dimensions) {
        this(name, defaultValue, dense, translator, dimensions, new int[dimensions.length]);
    }

    public BufferedGridValueLayer(String name, double defaultValue, boolean dense, GridPointTranslator translator, int[] dimensions, int[] origin) {
        this.read = new GridValueLayer(name, defaultValue, dense, translator, dimensions, origin);
        this.write = new GridValueLayer(name, defaultValue, dense, translator, dimensions, origin);
    }

    @Override
    public double get(double ... coordinate) {
        return this.read.get(coordinate);
    }

    public void forEach(GridFunction function, GridPoint origin, Buffer buffer, int ... extent) {
        if (buffer == Buffer.READ) {
            this.read.forEach(function, origin, extent);
        } else if (buffer == Buffer.WRITE) {
            this.write.forEach(function, origin, extent);
        }
    }

    @Override
    public Dimensions getDimensions() {
        return this.read.getDimensions();
    }

    @Override
    public String getName() {
        return this.read.getName();
    }

    @Override
    public void set(double value, int ... coordinate) {
        this.write.set(value, coordinate);
    }

    public void swap() {
        GridValueLayer tmp = this.read;
        this.read = this.write;
        this.write = tmp;
    }

    public static enum Buffer {
        READ,
        WRITE;

    }
}

