/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import repast.simphony.random.RandomHelper;
import repast.simphony.util.SimUtilities;
import repast.simphony.util.collections.IndexedIterable;

public class RandomIterable<T>
implements Iterator<T>,
Iterable<T> {
    protected int index;
    protected List<T> list;
    protected boolean[] returned;
    protected int numToReturn;
    protected int numReturned;

    public RandomIterable(IndexedIterable<T> iter, long count) {
        this.list = new ArrayList<T>(iter.size());
        for (Object obj : iter) {
            this.list.add(obj);
        }
        SimUtilities.shuffle(this.list, RandomHelper.getUniform());
        if (count != Long.MAX_VALUE) {
            int size = (int)count > iter.size() ? iter.size() : (int)count;
            this.list = this.list.subList(0, size);
        }
        this.numToReturn = this.list.size();
        this.returned = new boolean[this.numToReturn];
        this.index = 0;
        this.numReturned = 0;
    }

    @Override
    public boolean hasNext() {
        return this.numReturned < this.numToReturn;
    }

    @Override
    public T next() {
        int i;
        while (this.returned[i = this.index++]) {
        }
        this.returned[i] = true;
        ++this.numReturned;
        return this.list.get(i);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    protected void removeEvent(T target) {
        int i = this.list.indexOf(target);
        if (i != -1 && !this.returned[i]) {
            this.returned[i] = true;
            --this.numToReturn;
        }
    }
}

