/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import repast.simphony.util.collections.Tree;
import repast.simphony.util.collections.TreeVisitor;

public class NaryTree<T>
implements Tree<T> {
    private Node<T> root;
    private Map<T, Node<T>> objNodeMap = new HashMap<T, Node<T>>();

    public NaryTree(T rootObj) {
        this.root = new Node<T>(rootObj, null);
        this.objNodeMap.put(rootObj, this.root);
    }

    @Override
    public T getRoot() {
        return this.root.obj;
    }

    @Override
    public Collection<T> getChildren(T obj) {
        Node<T> parentNode = this.objNodeMap.get(obj);
        if (parentNode == null) {
            throw new IllegalArgumentException("Parent node '" + obj + "' is not in the tree");
        }
        ChildIterator<T> children = new ChildIterator<T>(parentNode);
        ArrayList<T> childList = new ArrayList<T>();
        for (T child : children) {
            childList.add(child);
        }
        return childList;
    }

    @Override
    public void addNode(T parent, T child) {
        Node<T> parentNode = this.objNodeMap.get(parent);
        if (parentNode == null) {
            throw new IllegalArgumentException("Parent node '" + parent + "' is not in the tree");
        }
        Node<T> node = new Node<T>(child, parentNode);
        parentNode.addChild(node);
        this.objNodeMap.put(child, node);
    }

    public Collection<T> getSiblings(T obj) {
        if (obj == null) {
            return null;
        }
        Node<T> node = this.objNodeMap.get(obj);
        return this.getChildren(node.parent.obj);
    }

    @Override
    public boolean removeNode(T obj) {
        Node<T> parent;
        Node<T> node = this.objNodeMap.remove(obj);
        if (node != null && (parent = node.parent) != null) {
            parent.removeChild(node);
            this.removeChildrenFromMap(node);
            return true;
        }
        return false;
    }

    private void removeChildrenFromMap(Node<T> node) {
        if (node.children != null) {
            for (Node child : node.children) {
                this.objNodeMap.remove(child.obj);
                this.removeChildrenFromMap(child);
            }
        }
    }

    @Override
    public void replaceNode(T oldObj, T newObj) {
        Node<T> node = this.objNodeMap.remove(oldObj);
        if (node == null) {
            throw new IllegalArgumentException("Node to replace '" + oldObj + "' is not in the tree");
        }
        node.obj = newObj;
        this.objNodeMap.put(newObj, node);
    }

    @Override
    public void sortChildren(Comparator<T> comparator) {
        this.sortChildren(this.root, new NodeComparator<T>(comparator));
    }

    private void sortChildren(Node<T> parent, NodeComparator<T> comparator) {
        if (parent.children != null) {
            for (Node child : parent.children) {
                this.sortChildren(child, comparator);
            }
            Collections.sort(parent.children, comparator);
        }
    }

    @Override
    public int size() {
        return this.objNodeMap.size();
    }

    @Override
    public void preOrderTraversal(TreeVisitor<T> visitor) {
        this.preOrderTraverals(this.root, visitor);
    }

    private void preOrderTraverals(Node<T> node, TreeVisitor<T> visitor) {
        visitor.visit(node.obj);
        if (node.children != null) {
            for (Node child : node.children) {
                this.preOrderTraverals(child, visitor);
            }
        }
    }

    protected void preOrderTraveralsOfNodes(Node<T> node, TreeVisitor<Node<T>> visitor) {
        visitor.visit(node);
        if (node.children != null) {
            for (Node child : node.children) {
                this.preOrderTraveralsOfNodes(child, visitor);
            }
        }
    }

    protected boolean containsChecker(Node<T> node, T parent, T child) {
        if (node.obj.equals(parent)) {
            return node.children.contains(child);
        }
        for (Node childNode : node.children) {
            if (!this.containsChecker(childNode, parent, child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T parent, T child) {
        return this.containsChecker(this.root, parent, child);
    }

    protected class ChildIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private Iterator<Node<T>> EMPTY_ITER = new ArrayList().iterator();
        private Iterator<Node<T>> children;

        public ChildIterator(Node<T> parentNode) {
            this.children = parentNode.children == null ? this.EMPTY_ITER : parentNode.children.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.children.hasNext();
        }

        @Override
        public T next() {
            Node<T> node = this.children.next();
            return node.obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    class Node<T> {
        T obj;
        Node<T> parent;
        List<Node<T>> children;

        public Node(T obj, Node<T> parent) {
            this.obj = obj;
            this.parent = parent;
        }

        void addChild(Node<T> node) {
            if (this.children == null) {
                this.children = new ArrayList<Node<T>>();
            }
            this.children.add(node);
        }

        void removeChild(Node<T> child) {
            if (this.children != null) {
                this.children.remove(child);
                if (this.children.size() == 0) {
                    this.children = null;
                }
            }
        }
    }

    protected class NodeComparator<T>
    implements Comparator<Node<T>> {
        private Comparator<T> comp;

        public NodeComparator(Comparator<T> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            return this.comp.compare(o1.obj, o2.obj);
        }
    }
}

