/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections15.Predicate;

public class FilteredIterator<X>
implements Iterator<X>,
Iterable<X> {
    private Predicate<X> predicate;
    private Iterator<X> innerIterator;
    private X cached = null;
    private boolean scanAll;

    public FilteredIterator(Iterator<X> innerIterator, Predicate<X> predicate) {
        this(innerIterator, predicate, true);
    }

    public FilteredIterator(Iterator<X> innerIterator, Predicate<X> predicate, boolean scanAll) {
        this.predicate = predicate;
        this.innerIterator = innerIterator;
        this.scanAll = scanAll;
    }

    @Override
    public X next() {
        if (this.innerIterator == null) {
            this.cached = null;
            throw new NoSuchElementException("No more elements in the Iterator");
        }
        if (this.cached == null && !this.innerIterator.hasNext()) {
            throw new NoSuchElementException("No more elements in the Iterator");
        }
        if (!this.cache()) {
            this.cached = null;
            throw new NoSuchElementException("No more elements in the Iterator");
        }
        X tmp = this.cached;
        this.cached = null;
        return tmp;
    }

    private boolean cache() {
        if (this.cached != null) {
            return true;
        }
        boolean result = false;
        do {
            if (!this.innerIterator.hasNext()) {
                result = false;
                break;
            }
            this.cached = this.innerIterator.next();
        } while (!(result = this.predicate.evaluate(this.cached)) && this.scanAll);
        if (!result) {
            this.cached = null;
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        if (this.cached != null) {
            return true;
        }
        if (this.innerIterator == null || !this.innerIterator.hasNext()) {
            return false;
        }
        return this.cache();
    }

    @Override
    public Iterator<X> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported.");
    }
}

