/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util.collections;

import java.lang.reflect.Method;
import java.util.Iterator;
import simphony.util.messages.MessageCenter;

public class DelegatedIterable<AGENT_TYPE>
implements Iterable<AGENT_TYPE> {
    private static final MessageCenter l4jLogger = MessageCenter.getMessageCenter(DelegatedIterable.class);
    private Object toCallOn;
    private Method methodToCall;

    public DelegatedIterable(Object toCallOn, Method methodToCall) {
        this.toCallOn = toCallOn;
        this.methodToCall = methodToCall;
    }

    @Override
    public Iterator<AGENT_TYPE> iterator() {
        try {
            return (Iterator)this.methodToCall.invoke(this.toCallOn, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            l4jLogger.error((Object)"DelegatedIterator.getObjects: Error, the given method does not take 0 arguments", (Throwable)e, new Object[0]);
            return null;
        }
        catch (ClassCastException e) {
            l4jLogger.error((Object)"DelegatedIterator.getObjects: Error, the given method did not return a java.lang.Iterable", (Throwable)e, new Object[0]);
            return null;
        }
        catch (Exception e) {
            l4jLogger.error((Object)"DelegatedIterator.getObjects: Error calling the given method.", (Throwable)e, new Object[0]);
            return null;
        }
    }

    public int hashCode() {
        return this.toCallOn.hashCode() ^ this.methodToCall.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DelegatedIterable) {
            DelegatedIterable dosObj = (DelegatedIterable)obj;
            return dosObj.toCallOn.equals(this.toCallOn) && dosObj.methodToCall.equals(this.methodToCall);
        }
        return false;
    }
}

