/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections15.iterators.IteratorChain;
import repast.simphony.util.collections.IndexedIterable;
import repast.simphony.util.collections.ListIndexedIterable;

public class CompositeIndexedIterable<T>
implements IndexedIterable<T> {
    private List<Range<T>> ranges = new ArrayList<Range<T>>();
    private Range<T> currentRange = new Range(-1, new ListIndexedIterable(new ArrayList()));
    private int start = 0;

    public void addIndexedIterable(IndexedIterable<T> iter) {
        this.ranges.add(new Range<T>(this.start, iter));
        this.start += iter.size();
    }

    public void addList(List<T> list) {
        this.ranges.add(new Range<T>(this.start, new ListIndexedIterable<T>(list)));
        this.start += list.size();
    }

    @Override
    public T get(int index) {
        if (index < 0 || index > this.start - 1) {
            throw new IndexOutOfBoundsException("Index: " + index + " is out of bounds [0, " + (this.start - 1) + "]");
        }
        T obj = this.currentRange.get(index);
        if (obj != null) {
            return obj;
        }
        int i = 0;
        int n = this.ranges.size();
        while (i < n) {
            Range<T> range = this.ranges.get(i);
            obj = range.get(index);
            if (obj != null) {
                this.currentRange = range;
                return obj;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int size() {
        return this.start;
    }

    @Override
    public Iterator<T> iterator() {
        IteratorChain iter = new IteratorChain();
        int i = 0;
        int n = this.ranges.size();
        while (i < n) {
            Range<T> range = this.ranges.get(i);
            iter.addIterator(((Range)range).list.iterator());
            ++i;
        }
        return iter;
    }

    private static class Range<T> {
        private int start;
        private int end;
        private IndexedIterable<T> list;

        public Range(int start, IndexedIterable<T> list) {
            this.list = list;
            this.start = start;
            this.end = start + list.size();
        }

        public T get(int index) {
            if (index >= this.start && index < this.end) {
                return this.list.get(index - this.start);
            }
            return null;
        }
    }
}

