/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util.bytecode;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import repast.simphony.util.bytecode.DataSource;

public class ByteCodeUtilities {
    private int counter = 0;
    private Map<String, DataSource> sourceCache = new HashMap<String, DataSource>();
    private Map<Class, String> templateMap = new HashMap<Class, String>();
    private static ByteCodeUtilities instance;

    static {
        ClassPool.getDefault().appendClassPath((ClassPath)new LoaderClassPath(ByteCodeUtilities.class.getClassLoader()));
        instance = new ByteCodeUtilities();
    }

    private ByteCodeUtilities() {
        this.templateMap.put(Integer.TYPE, "new Integer($body$)");
        this.templateMap.put(Double.TYPE, "new Double($body$)");
        this.templateMap.put(Float.TYPE, "new Float($body$)");
        this.templateMap.put(Long.TYPE, "new Long($body$)");
        this.templateMap.put(Short.TYPE, "new Short($body$)");
        this.templateMap.put(Byte.TYPE, "new Byte($body$)");
        this.templateMap.put(Boolean.TYPE, "Boolean.valueOf($body$)");
    }

    public static ByteCodeUtilities getInstance() {
        return instance;
    }

    public DataSource createMethodCall(Method method) throws NotFoundException, CannotCompileException, IllegalAccessException, InstantiationException {
        Class<?> retType = method.getReturnType();
        Class<?> objType = method.getDeclaringClass();
        if (retType.equals(Void.TYPE) || method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method '" + method.getName() + "' cannot be wrapped in " + "a DataSource");
        }
        String methodId = String.valueOf(objType.getName()) + "." + method.getName();
        DataSource source = this.sourceCache.get(methodId);
        if (source == null) {
            ClassPool pool = ClassPool.getDefault();
            CtClass clazz = pool.makeClass("repast.simphony.util.bytecode.__DataSource" + this.counter++);
            clazz.addInterface(pool.get("repast.simphony.util.bytecode.DataSource"));
            StringBuilder methodStr = new StringBuilder("public Object getData(Object obj) {return ");
            String template = this.templateMap.get(retType);
            if (template == null) {
                template = "$body$";
            }
            StringBuilder bodyStr = new StringBuilder("((");
            bodyStr.append(objType.getName());
            bodyStr.append(")obj).");
            bodyStr.append(method.getName());
            bodyStr.append("()");
            methodStr.append(template.replace("$body$", bodyStr));
            methodStr.append(";}");
            CtMethod ctMethod = CtMethod.make((String)methodStr.toString(), (CtClass)clazz);
            clazz.addMethod(ctMethod);
            ClassLoader loader = this.getClass().getClassLoader();
            source = (DataSource)clazz.toClass(loader, this.getClass().getProtectionDomain()).newInstance();
            this.sourceCache.put(methodId, source);
        }
        return source;
    }
}

