/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import simphony.util.messages.MessageCenter;

public class VelocityUtils {
    private static final MessageCenter l4jLogger = MessageCenter.getMessageCenter(VelocityUtils.class);

    static {
        try {
            Velocity.init();
        }
        catch (Exception e) {
            l4jLogger.error((Object)"VelocityUtils.static: Error initializing the velocity parsing library.", (Throwable)e, new Object[0]);
        }
    }

    public static String evaluate(VelocityContext context, String toParse, String valueOnError) {
        StringWriter writer = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)writer, (String)toParse, (String)toParse);
            return writer.toString();
        }
        catch (Exception e) {
            l4jLogger.warn((Object)("VelocityUtils.evaluate: Error evaluating variable based string(" + toParse + "), returning(" + valueOnError + ")."), (Throwable)e, new Object[0]);
            return valueOnError;
        }
    }

    public static ArrayList<String> getTemplateVarNames(String toParse) {
        SimpleNode nodeTree = null;
        ArrayList<String> varNames = new ArrayList<String>();
        try {
            nodeTree = RuntimeSingleton.parse((Reader)new BufferedReader(new StringReader(toParse)), (String)toParse);
        }
        catch (Exception e) {
            l4jLogger.error((Object)("VelocityUtils.templateVarNames: Error finding variable names in string(" + toParse + ")"), (Throwable)e, new Object[0]);
            return null;
        }
        if (nodeTree != null) {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl((Context)new VelocityContext());
            ica.pushCurrentTemplateName(toParse);
            try {
                nodeTree.init((InternalContextAdapter)ica, (Object)RuntimeSingleton.getRuntimeServices());
                int i = 0;
                while (i < nodeTree.jjtGetNumChildren()) {
                    Node node = nodeTree.jjtGetChild(i);
                    if (node instanceof ASTReference) {
                        varNames.add(((ASTReference)node).getRootString());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                l4jLogger.error((Object)("VelocityUtils.templateVarNames: Error finding variable names in string(" + toParse + ")"), (Throwable)e, new Object[0]);
                return null;
            }
        }
        return varNames;
    }
}

