/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import cern.jet.random.Uniform;
import java.math.BigDecimal;
import java.util.List;
import simphony.util.messages.MessageCenter;

public class SimUtilities {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(SimUtilities.class);
    private static double[] sinArray = new double[360];
    private static double[] cosArray = new double[360];

    static {
        int i = 0;
        while (i < 360) {
            SimUtilities.sinArray[i] = Math.sin((double)i * (Math.PI / 180));
            SimUtilities.cosArray[i] = Math.cos((double)i * (Math.PI / 180));
            ++i;
        }
    }

    public static String capitalize(String str) {
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static void shuffle(List list, Uniform rng) {
        int i = list.size();
        while (i > 1) {
            SimUtilities.swap(list, i - 1, rng.nextIntFromTo(0, i - 1));
            --i;
        }
    }

    public static void shuffle(double[] array, Uniform rng) {
        int i = array.length;
        while (i > 1) {
            SimUtilities.swap(array, i - 1, rng.nextIntFromTo(0, i - 1));
            --i;
        }
    }

    private static void swap(List list, int i, int j) {
        Object tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    private static void swap(double[] array, int i, int j) {
        double tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    public static double[] getPointFromHeadingAndDistance(int heading, int distance) {
        double y = sinArray[heading] * (double)distance;
        double x = cosArray[heading] * (double)distance;
        double[] retVal = new double[]{x, y};
        return retVal;
    }

    public static int norm(int val, int size) {
        if (val < 0 || val > size - 1) {
            while (val < 0) {
                val += size;
            }
            return val % size;
        }
        return val;
    }

    public static double scale(double value, int decimalPlaces) {
        return new BigDecimal(value).setScale(decimalPlaces, 4).doubleValue();
    }
}

