/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.IOException;
import simphony.settings.SettingsIO;
import simphony.settings.SettingsRegistry;
import simphony.util.messages.MessageCenter;

public class Settings {
    public static final String SETTINGS_FILE_NAME = "Repast.settings";
    public static final String SETTINGS_REGISTRY_ID = "Repast.registry";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(Settings.class);
    private static SettingsRegistry settingsRegistry;

    public static SettingsRegistry getRegistry() {
        if (settingsRegistry == null) {
            try {
                settingsRegistry = SettingsRegistry.getRegistry((String)SETTINGS_REGISTRY_ID, (String)SETTINGS_FILE_NAME);
            }
            catch (RuntimeException ex) {
                settingsRegistry = new SettingsRegistry(SETTINGS_REGISTRY_ID);
                LOG.warn((Object)"Error while loading Repast settings, will continue with default settings", (Throwable)ex, new Object[0]);
            }
        }
        return settingsRegistry;
    }

    public static void storeSettings() throws IOException {
        SettingsIO.storeSettings((SettingsRegistry)settingsRegistry, (String)SETTINGS_FILE_NAME);
    }

    public static Object get(String key) {
        return Settings.getRegistry().get((Object)key);
    }

    public static void put(String key, Object value) {
        Settings.getRegistry().put(key, value);
    }
}

