/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.IOException;
import java.io.StringReader;
import java.nio.BufferUnderflowException;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simphony.util.messages.MessageCenter;

public class Scanner
implements Iterator<String> {
    public static final int BUF_SIZE = 1024;
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(Scanner.class);
    protected CharBuffer buf = CharBuffer.allocate(1024);
    protected boolean eof = false;
    protected Readable source;
    private Matcher delimMatcher;
    private Pattern delimPattern;
    private IOException ioException;

    private Scanner() {
        this.buf.limit(0);
        this.useDelimiter("\\s");
    }

    public Scanner(String source) {
        this();
        this.source = new StringReader(source);
    }

    public Scanner(Readable source) {
        this();
        this.source = source;
    }

    public Scanner(ReadableByteChannel channel) {
        this();
        this.source = this.getReadable(channel, null);
    }

    public Scanner(ReadableByteChannel channel, String charset) {
        this();
        this.source = this.getReadable(channel, charset);
    }

    private Readable getReadable(ReadableByteChannel channel, String charset) {
        if (charset == null) {
            return Channels.newReader(channel, Charset.defaultCharset().name());
        }
        return Channels.newReader(channel, charset);
    }

    private void syncDelimMatcherToBuf() {
        this.delimMatcher.region(0, this.buf.length());
    }

    protected void buffer() {
        this.buf.compact();
        int availLength = this.buf.length();
        try {
            int readLength = this.source.read(this.buf);
            if (availLength != readLength) {
                this.eof = true;
            }
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        this.buf.limit(this.buf.position());
        this.buf.position(0);
        this.syncDelimMatcherToBuf();
    }

    protected void handleIOException(IOException e) {
        this.eof = true;
        this.ioException = e;
    }

    protected void bufferMore() {
        this.buf.compact();
        CharBuffer grownBuf = CharBuffer.allocate(this.buf.capacity() * 2);
        int oldPosition = this.buf.position();
        this.buf.position(0);
        this.buf.limit(oldPosition);
        grownBuf.put(this.buf);
        this.buf = grownBuf;
        if (this.delimMatcher != null) {
            this.delimMatcher.reset(this.buf);
        }
        this.buffer();
    }

    @Override
    public boolean hasNext() {
        return !this.eof || this.buf.position() != this.buf.limit();
    }

    @Override
    public String next() {
        return this.getNextDelimited();
    }

    public String getNextDelimited() {
        if (!this.hasNext()) {
            NoSuchElementException ex = new NoSuchElementException("No more elements");
            msgCenter.error((Object)"Scanner.getNextDelimiter: No more elements", (Throwable)ex, new Object[0]);
            throw ex;
        }
        this.verifyDataAvailable();
        this.syncDelimMatcherToBuf();
        String matchedString = null;
        while (matchedString == null) {
            boolean sawMatch = this.delimMatcher.find();
            if (!sawMatch && this.eof) {
                return this.getStringFromBuf(0, this.buf.length());
            }
            if (!sawMatch && !this.eof) {
                this.bufferMore();
                continue;
            }
            if (this.delimMatcher.hitEnd() && !this.eof) {
                this.bufferMore();
                continue;
            }
            int delimStart = this.delimMatcher.start();
            int delimEnd = this.delimMatcher.end();
            matchedString = this.getStringFromBuf(0, delimStart);
            this.buf.position(this.buf.position() + delimEnd - delimStart);
        }
        return matchedString;
    }

    public String getNextPattern(String pattern) {
        this.verifyDataAvailable();
        Matcher matcher = Pattern.compile(pattern, 32).matcher(this.buf);
        String matchedString = null;
        while (matchedString == null) {
            boolean sawMatch = matcher.lookingAt();
            if (!sawMatch && !matcher.hitEnd()) {
                InputMismatchException ex = new InputMismatchException("Didn't find match");
                msgCenter.error((Object)"Couldn't find a match for the specified pattern", (Throwable)ex, new Object[0]);
                throw ex;
            }
            if (matcher.hitEnd() && !this.eof) {
                this.bufferMore();
                matcher.reset();
                continue;
            }
            matchedString = this.getStringFromBuf(0, matcher.end());
        }
        return matchedString;
    }

    public String getNextLength(int length) {
        try {
            this.verifyDataAvailable();
            return this.getStringFromBuf(0, length);
        }
        catch (BufferUnderflowException ex) {
            NoSuchElementException except = new NoSuchElementException("Could not retrieve " + length + " characters");
            msgCenter.error((Object)"Scanner.getNextLength: no more elements", (Throwable)except, new Object[0]);
            throw except;
        }
    }

    private String getStringFromBuf(int start, int length) {
        return this.getStringFromBuf(start, length, true);
    }

    private String getStringFromBuf(int start, int length, boolean moveBufPos) {
        char[] matchedChars = new char[length];
        this.buf.get(matchedChars, start, length);
        if (!moveBufPos) {
            this.buf.position(this.buf.position() - length);
        }
        return new String(matchedChars);
    }

    private void verifyDataAvailable() {
        if (this.buf.limit() == 0) {
            this.buffer();
        }
        if (this.eof && this.buf.position() == this.buf.limit()) {
            throw new NoSuchElementException("At end of file");
        }
    }

    public Pattern useDelimiter(String delimiter) {
        return this.useDelimiter(Pattern.compile(delimiter));
    }

    public Pattern useDelimiter(Pattern delimiterPattern) {
        Pattern oldDelimiter = this.delimPattern;
        this.delimPattern = delimiterPattern;
        this.delimMatcher = this.delimPattern.matcher(this.buf);
        return oldDelimiter;
    }

    public Pattern delimiter() {
        return this.delimPattern;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public IOException ioException() {
        return this.ioException;
    }
}

