/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import repast.simphony.util.IntRange;

public class RangeCombination {
    private List<IntRange> ranges = new ArrayList<IntRange>();
    private boolean done;
    private int[] current;

    public RangeCombination(List<IntRange> ranges) {
        this.ranges.addAll(ranges);
        this.current = new int[ranges.size()];
        this.done = false;
        this.setCurrent();
    }

    public int numRanges() {
        return this.ranges.size();
    }

    public void next(int[] value) {
        if (this.done) {
            throw new NoSuchElementException("All combinations have been returned");
        }
        System.arraycopy(this.current, 0, value, 0, this.current.length);
        if (this.ranges.get(0).hasNext()) {
            this.ranges.get(0).next();
            this.setCurrent();
        } else {
            int index = 0;
            int limit = this.ranges.size() - 1;
            int i = 1;
            while (i <= limit) {
                if (this.hasNext(i)) break;
                if (i == limit) {
                    this.done = true;
                    break;
                }
                index = i++;
            }
            if (!this.done) {
                this.ranges.get(index + 1).next();
                int j = 0;
                while (j <= index) {
                    this.ranges.get(j).reset();
                    ++j;
                }
            }
            this.setCurrent();
        }
    }

    public boolean hasNext() {
        return !this.done;
    }

    private void setCurrent() {
        int i = 0;
        int n = this.ranges.size();
        while (i < n) {
            this.current[i] = this.ranges.get(i).getValue();
            ++i;
        }
    }

    private boolean hasNext(int rangeIndex) {
        return this.ranges.get(rangeIndex).hasNext();
    }

    public static class RangeComboBuilder {
        List<IntRange> ranges = new ArrayList<IntRange>();

        public void addRange(int min, int max) {
            this.addRange(min, max, 1);
        }

        public void addRange(int min, int max, int step) {
            this.ranges.add(new IntRange(min, max, step));
        }

        public RangeCombination build() {
            return new RangeCombination(this.ranges);
        }
    }
}

