/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Stack;
import repast.simphony.util.Scanner;

public class RandomAccessScanner
extends Scanner {
    protected FileChannel fileChannel;
    protected Stack<Long> markStack;

    public RandomAccessScanner(FileChannel channel, String charset) {
        super(channel, charset);
        this.init();
        this.fileChannel = channel;
    }

    public RandomAccessScanner(FileChannel channel) {
        super(channel);
        this.init();
        this.fileChannel = channel;
    }

    public RandomAccessScanner(String source) {
        super(source);
        this.init();
    }

    private void init() {
        this.markStack = new Stack();
    }

    private long getFileOffsetInternal() throws IOException {
        if (this.fileChannel != null) {
            return this.fileChannel.position();
        }
        return -1L;
    }

    public long getPosition() throws IOException {
        long fileOffset = this.getFileOffsetInternal();
        if (fileOffset <= 0L) {
            return fileOffset;
        }
        return fileOffset - (long)this.buf.length();
    }

    protected int getBufferLength() {
        return this.buf.length();
    }

    protected void syncToSource() {
        this.buf.clear();
        this.buf.position(0);
        this.buf.limit(0);
        this.eof = false;
    }

    public void mark() throws IOException {
        this.markStack.push(this.getPosition());
    }

    public Long popMark() {
        if (!this.markStack.isEmpty()) {
            return this.markStack.pop();
        }
        return null;
    }

    public void reset() throws IOException {
        this.position(this.markStack.peek());
    }

    public void position(long position) throws IOException {
        this.fileChannel.position(position);
        this.syncToSource();
        this.buffer();
    }
}

