/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.util.Comparator;
import java.util.NoSuchElementException;

public class PriorityQueue<T> {
    private int maxSize;
    private int origMax;
    private int currentSize = 0;
    private boolean orderOk = true;
    private T minValue;
    private Object[] array;
    private Comparator<T> comp;

    public PriorityQueue(T minValue, Comparator<T> comp) {
        this(minValue, comp, 13);
    }

    public PriorityQueue(T minValue, Comparator<T> comp, int size) {
        this.maxSize = size;
        this.origMax = size;
        this.allocateArray(size);
        this.comp = comp;
        this.minValue = minValue;
        this.array[0] = minValue;
    }

    private void checkSize() {
        if (this.currentSize == this.maxSize) {
            Object[] old = this.array;
            this.allocateArray(this.maxSize * 2);
            System.arraycopy(old, 0, this.array, 0, old.length);
            old = null;
            this.maxSize *= 2;
        }
    }

    private void percolateDown(int hole) {
        if (this.currentSize > 0) {
            Object tmp = this.array[hole];
            while (hole * 2 <= this.currentSize) {
                int child = hole * 2;
                if (child != this.currentSize && this.comp.compare(this.array[child + 1], this.array[child]) < 0) {
                    ++child;
                }
                if (this.comp.compare(this.array[child], tmp) >= 0) break;
                this.array[hole] = this.array[child];
                hole = child;
            }
            this.array[hole] = tmp;
        }
    }

    public void insert(T obj) {
        if (!this.orderOk) {
            this.toss(obj);
            return;
        }
        this.checkSize();
        int hole = ++this.currentSize;
        if (hole != 1) {
            while (this.comp.compare(obj, this.array[hole / 2]) < 0) {
                this.array[hole] = this.array[hole / 2];
                hole /= 2;
            }
        }
        this.array[hole] = obj;
    }

    public T peekMin() {
        if (this.currentSize == 0) {
            throw new NoSuchElementException("Queue is Empty");
        }
        if (!this.orderOk) {
            this.fixHeap();
        }
        return (T)this.array[1];
    }

    public T popMin() {
        T a = this.peekMin();
        this.array[1] = this.array[this.currentSize--];
        this.percolateDown(1);
        return a;
    }

    public void toss(T obj) {
        this.checkSize();
        this.array[++this.currentSize] = obj;
        if (this.currentSize != 1 && this.comp.compare(obj, this.array[this.currentSize / 2]) < 0) {
            this.orderOk = false;
        }
    }

    public void clear() {
        this.currentSize = 0;
        this.orderOk = true;
        this.allocateArray(this.origMax);
        this.maxSize = this.origMax;
        this.array[0] = this.minValue;
    }

    public void fixHeap() {
        int i = this.currentSize / 2;
        while (i > 0) {
            this.percolateDown(i);
            --i;
        }
        this.orderOk = true;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public int size() {
        return this.currentSize;
    }

    private void allocateArray(int newMaxSize) {
        this.array = new Object[newMaxSize + 1];
    }
}

