/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileUtils {
    public static File backupDir(File dirToBackup) throws IOException {
        return FileUtils.backupDir(dirToBackup, dirToBackup.getParentFile());
    }

    public static File backupDir(File dirToBackup, File backupParentDir) throws IOException {
        File bakDir = new File(backupParentDir, String.valueOf(dirToBackup.getName()) + ".bak");
        int count = 0;
        while (bakDir.exists()) {
            bakDir = new File(backupParentDir, String.valueOf(dirToBackup.getName()) + ".bak" + count++);
        }
        FileUtils.copyDirs(dirToBackup, bakDir);
        return bakDir;
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (source.equals(dest)) {
            throw new IOException("Source and destination cannot be the same file path");
        }
        FileChannel srcChannel = new FileInputStream(source).getChannel();
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileChannel dstChannel = new FileOutputStream(dest).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    public static void copyDirs(File sourceDir, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] fileArray = sourceDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtils.copyDirs(file, new File(destDir, file.getName()));
            } else {
                FileChannel srcChannel = new FileInputStream(file).getChannel();
                File out = new File(destDir, file.getName());
                out.createNewFile();
                FileChannel dstChannel = new FileOutputStream(out).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
            }
            ++n2;
        }
    }

    public static void deleteIgnoreVC(File file, final String ... filesToIgnore) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    String[] stringArray = filesToIgnore;
                    int n = filesToIgnore.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        if (name.matches(fileName)) {
                            return false;
                        }
                        ++n2;
                    }
                    return !name.endsWith(".cvs") && !name.endsWith(".svn");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtils.deleteIgnoreVC(child, new String[0]);
                ++n2;
            }
        }
        file.delete();
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtils.delete(child);
                ++n2;
            }
        }
        file.delete();
    }

    public static File getDataFile(String filename) {
        File file = new File(filename);
        if (file.exists()) {
            return file;
        }
        file = new File("./data/" + filename);
        if (file.exists()) {
            return file;
        }
        file = new File("./demos/data/" + filename);
        if (file.exists()) {
            return file;
        }
        file = new File("./repast/demos/data/" + filename);
        if (file.exists()) {
            return file;
        }
        file = new File("./demos/" + filename);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getDataFileName(String filename) {
        File file = FileUtils.getDataFile(filename);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static void main(String[] args) {
        try {
            FileUtils.backupDir(new File("c:/tmp/info"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

