/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections15.Predicate;
import repast.simphony.context.Context;
import repast.simphony.engine.controller.ContextTraverser;
import repast.simphony.engine.environment.RunState;
import repast.simphony.util.collections.CollectionUtils;

public class ContextUtils {
    public static <T> Context<? extends T> findContext(Context<T> start, final Object id) {
        return CollectionUtils.breadthFirstSearch(new Predicate<Context>(){

            public boolean evaluate(Context context) {
                return context.getId().equals(id);
            }
        }, new ContextTraverser(), start);
    }

    public static Context getContext(Object o) {
        if (RunState.getInstance() == null) {
            return null;
        }
        if (RunState.getInstance().getMasterContext() == null) {
            return null;
        }
        return ContextUtils.getContext(RunState.getInstance().getMasterContext(), o);
    }

    public static Context getContext(Context<?> startingContext, Object o) {
        Context contextFound = null;
        ArrayList list = new ArrayList();
        list.add(startingContext);
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            Context context = (Context)iter.next();
            if (!context.contains(o)) continue;
            contextFound = context;
            if (context.getSubContexts() == null) break;
            iter = context.getSubContexts().iterator();
        }
        return contextFound;
    }

    public static Context getParentContext(Context context) {
        Context master = RunState.getInstance().getMasterContext();
        return ContextUtils.getParentContext(master, context);
    }

    public static Context getParentContext(Context startingContext, Context context) {
        for (Context child : startingContext.getSubContexts()) {
            if (child.equals(context)) {
                return startingContext;
            }
            Context parent = ContextUtils.getParentContext(child, context);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }
}

