/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import simphony.util.messages.MessageCenter;

public class ClassUtilities {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(ClassUtilities.class);
    public static boolean doWarn = true;
    private static Set<Class> numberTypeSet = new HashSet<Class>();

    static {
        numberTypeSet.add(Integer.TYPE);
        numberTypeSet.add(Double.TYPE);
        numberTypeSet.add(Float.TYPE);
        numberTypeSet.add(Byte.TYPE);
        numberTypeSet.add(Short.TYPE);
        numberTypeSet.add(Long.TYPE);
    }

    public static Field deepFindField(Class clazz, String name) throws NoSuchFieldException {
        NoSuchFieldException exp = null;
        while (clazz != null) {
            Field field = null;
            try {
                field = clazz.getDeclaredField(name);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (exp == null) {
                    exp = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw exp;
    }

    public static boolean isNumericType(Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return numberTypeSet.contains(clazz);
    }

    public static Method[] findMethods(Class<?> clazz, Class<? extends Annotation> ... annotationsToLookFor) {
        ArrayList<Method> methodsWithAnnotation = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            boolean add = true;
            Class<? extends Annotation>[] classArray = annotationsToLookFor;
            int n3 = annotationsToLookFor.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<? extends Annotation> annotation = classArray[n4];
                if (!method.isAnnotationPresent(annotation)) {
                    add = false;
                }
                ++n4;
            }
            if (add) {
                methodsWithAnnotation.add(method);
            }
            ++n2;
        }
        return methodsWithAnnotation.toArray(new Method[methodsWithAnnotation.size()]);
    }

    public static Field[] findFields(Class<?> clazz, Class<? extends Annotation> ... annotationsToLookFor) {
        ArrayList<Field> fieldsWithAnnotation = new ArrayList<Field>();
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            boolean add = true;
            Class<? extends Annotation>[] classArray = annotationsToLookFor;
            int n3 = annotationsToLookFor.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<? extends Annotation> annotation = classArray[n4];
                if (!field.isAnnotationPresent(annotation)) {
                    add = false;
                }
                ++n4;
            }
            if (add) {
                fieldsWithAnnotation.add(field);
            }
            ++n2;
        }
        return fieldsWithAnnotation.toArray(new Field[fieldsWithAnnotation.size()]);
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        Class<?> origClass = clazz;
        while (clazz != null) {
            Method[] methods = clazz.getMethods();
            Method method = ClassUtilities.doFindMethod(methods, methodName, params);
            if (method != null) {
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        Class[] newParams = new Class[params.length];
        boolean search = false;
        int i = 0;
        while (i < params.length) {
            Class<?> param = params[i];
            Class<?> primitive = ClassUtilities.convertObjectPrimitive(param);
            if (primitive != null) {
                newParams[i] = primitive;
                search = true;
            } else {
                newParams[i] = param;
            }
            ++i;
        }
        if (search) {
            clazz = origClass;
            while (clazz != null) {
                Method[] methods = clazz.getMethods();
                Method method = ClassUtilities.doFindMethod(methods, methodName, newParams);
                if (method != null) {
                    return method;
                }
                clazz = clazz.getSuperclass();
            }
        }
        ClassUtilities.warn("Utilities.findMethod: warning, could not find method '" + methodName + "(" + Arrays.deepToString(params) + ")' in class " + (origClass == null ? "null" : origClass.getName()) + ", " + "returning null");
        return null;
    }

    private static void warn(String msg) {
        if (doWarn) {
            msgCenter.warn((Object)msg, new Object[0]);
        }
    }

    private static void warn(String msg, Throwable ex) {
        if (doWarn) {
            msgCenter.warn((Object)msg, ex, new Object[0]);
        }
    }

    public static Method findFirstMethodWithArgs(Class clazz, String name, int argCount) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(name) && method.getGenericParameterTypes().length == argCount) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static String getPropertyName(String name) {
        if (name == null || name.equals("")) {
            ClassUtilities.warn("propertyName cannot be null or \"\" in getPropertyName, returning null");
            return null;
        }
        char firstChar = name.charAt(0);
        StringBuilder propertyName = new StringBuilder();
        propertyName.append(Character.toUpperCase(firstChar));
        propertyName.append(name.substring(1, name.length()));
        return propertyName.toString();
    }

    public static Method findSetter(Class<?> clazz, String propertyName, Class<?> ... args) {
        if ((propertyName = ClassUtilities.getPropertyName(propertyName)) == null) {
            ClassUtilities.warn("Invalid propertyName(" + propertyName + ")");
            return null;
        }
        return ClassUtilities.findMethod(clazz, "set" + propertyName, args);
    }

    public static boolean setValue(Object objToSetOn, String propertyName, Object value) {
        Method method = ClassUtilities.findSetter(objToSetOn.getClass(), propertyName, value.getClass());
        if (method == null) {
            return false;
        }
        try {
            method.invoke(objToSetOn, value);
            return true;
        }
        catch (Exception ex) {
            ClassUtilities.warn("Couldn't set value using method " + method.getName());
            return false;
        }
    }

    public static Object getValue(Object objToSetOn, String propertyName) {
        Method method = ClassUtilities.findGetter(objToSetOn.getClass(), propertyName, new Class[0]);
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(objToSetOn, new Object[0]);
        }
        catch (Exception ex) {
            ClassUtilities.warn("Couldn't get value using method " + method.getName());
            return null;
        }
    }

    public static Method findGetter(Class<?> clazz, String propertyName, Class<?> ... args) {
        if ((propertyName = ClassUtilities.getPropertyName(propertyName)) == null) {
            ClassUtilities.warn("Invalid propertyName(" + propertyName + ")");
            return null;
        }
        return ClassUtilities.findMethod(clazz, "get" + propertyName, args);
    }

    private static Class<?> convertObjectPrimitive(Class clazz) {
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        return null;
    }

    private static Method doFindMethod(Method[] methods, String methodName, Class<?> ... params) {
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName())) {
                Class<?>[] methodParams = method.getParameterTypes();
                if (methodParams.length == 0 && params == null) {
                    return method;
                }
                if ((methodParams.length == 0 || params != null) && methodParams.length == params.length) {
                    boolean match = true;
                    int i = 0;
                    while (i < params.length) {
                        if (!methodParams[i].isAssignableFrom(params[i])) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (match) {
                        return method;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public static <T extends Annotation> T deepAnnotationCheck(Method method, Class<T> annotationClass) throws SecurityException {
        T annotationInstance = method.getAnnotation(annotationClass);
        if (annotationInstance != null) {
            return annotationInstance;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> currentClass = method.getDeclaringClass();
        while (currentClass != null) {
            Class<?>[] declaringClassInterfaces;
            Class<?>[] classArray = declaringClassInterfaces = currentClass.getInterfaces();
            int n = declaringClassInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                T interfaceAnnotation;
                Class<?> inter = classArray[n2];
                Method interfaceMethod = ClassUtilities.findMethod(inter, methodName, parameterTypes);
                if (interfaceMethod != null && (interfaceAnnotation = interfaceMethod.getAnnotation(annotationClass)) != null) {
                    return interfaceAnnotation;
                }
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return null;
    }

    public static List<Class> getClasses(String classpath) throws IOException, ClassNotFoundException {
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<Class> classes = new ArrayList<Class>();
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            try {
                if (path.endsWith(".jar")) {
                    classes.addAll(ClassUtilities.getJarClasses(path));
                    continue;
                }
                int index = path.length() + 1;
                if (path.endsWith("\\") || path.endsWith("/")) {
                    index = path.length();
                }
                classes.addAll(ClassUtilities.getClasses(index, new File(path)));
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    private static List<? extends Class> getClasses(int index, File path) throws IOException {
        ArrayList<Class<Object>> classes;
        block5: {
            block4: {
                classes = new ArrayList<Class<Object>>();
                if (!path.isDirectory()) break block4;
                File[] fileArray = path.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    classes.addAll(ClassUtilities.getClasses(index, file));
                    ++n2;
                }
                break block5;
            }
            if (!path.getName().endsWith(".class")) break block5;
            String fname = path.getPath();
            fname = fname.substring(index, fname.length());
            fname = StringUtils.replace((String)fname, (String)File.separator, (String)".");
            try {
                classes.add(Class.forName(fname.substring(0, fname.length() - 6), false, ClassUtilities.class.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                ClassUtilities.warn("Error creating Class from *.class file", e);
            }
            catch (NoClassDefFoundError e) {
                ClassUtilities.warn("Error creating Class from *.class file", e);
            }
        }
        return classes;
    }

    private static List<? extends Class> getJarClasses(String path) throws IOException, ClassNotFoundException {
        JarFile jar = new JarFile(path);
        ArrayList classes = new ArrayList();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            name = StringUtils.replace((String)name, (String)"/", (String)".");
            try {
                Class<?> clazz = Class.forName(name.substring(0, name.length() - 6), false, ClassUtilities.class.getClassLoader());
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                ClassUtilities.warn("Error creating Class from *.class file", e);
            }
            catch (NoClassDefFoundError e) {
                ClassUtilities.warn("Error creating Class from *.class file", e);
            }
        }
        return classes;
    }
}

