/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.filter.Filter;
import repast.simphony.filter.OrFilter;
import repast.simphony.util.ClassFinder;
import repast.simphony.util.ClassPathFilter;

public class ClassPathEntry {
    private static Filter<String> ALWAYS_TRUE = new Filter<String>(){

        @Override
        public boolean evaluate(String object) {
            return true;
        }
    };
    private OrFilter<String> filter = new OrFilter();
    private File path;

    public ClassPathEntry(File path) {
        this.path = path;
    }

    public ClassPathEntry(File path, ClassPathFilter filter) {
        this.path = path;
        this.filter.addFilter(filter);
    }

    public ClassPathEntry(File path, List<String> filters) {
        this.path = path;
        for (String f : filters) {
            this.addFilter(f);
        }
    }

    public void addFilter(ClassPathFilter filter) {
        this.filter.addFilter(filter);
    }

    public void addFilter(String filter) {
        if (filter.equals("*")) {
            this.filter.addFilter(ALWAYS_TRUE);
        } else {
            this.filter.addFilter(new ClassPathFilter(filter));
        }
    }

    public File getPath() {
        return this.path;
    }

    public boolean filter(String className) {
        return this.filter.evaluate(className);
    }

    public boolean isValid() {
        return this.getClassPaths().size() > 0;
    }

    public Filter<String> getFilter() {
        return this.filter;
    }

    public List<File> getClassPaths() {
        ArrayList<File> entries = new ArrayList<File>();
        if (this.path.isDirectory()) {
            File[] fileArray = this.path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.getName().endsWith(".jar")) {
                    entries.add(child);
                }
                ++n2;
            }
            boolean found = this.containsClasses(this.path);
            if (found) {
                entries.add(this.path);
            }
        } else if (this.path.getName().endsWith(".jar")) {
            entries.add(this.path);
        }
        return entries;
    }

    private boolean containsClasses(File dir) {
        File file;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file.getName().endsWith(".class")) {
                return true;
            }
            ++n2;
        }
        fileArray = dir.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            boolean result;
            file = fileArray[n2];
            if (file.isDirectory() && (result = this.containsClasses(file))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Iterable<String> getClassNames() throws IOException, ClassNotFoundException {
        ClassFinder finder = new ClassFinder();
        finder.addEntry(this);
        return finder.findClassNames();
    }
}

