/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import repast.simphony.util.ClassPathEntry;

public class ClassFinder {
    private List<ClassPathEntry> entries = new ArrayList<ClassPathEntry>();

    public void addEntry(ClassPathEntry entry) {
        this.entries.add(entry);
    }

    public List<String> findClassNames() throws IOException, ClassNotFoundException {
        StringAdder adder = new StringAdder();
        for (ClassPathEntry entry : this.entries) {
            this.findClasses(entry, adder);
        }
        return new ArrayList<String>(adder.classes);
    }

    public List<Class<?>> findClasses() throws IOException, ClassNotFoundException {
        ClassAdder adder = new ClassAdder();
        for (ClassPathEntry entry : this.entries) {
            this.findClasses(entry, adder);
        }
        return new ArrayList(adder.classes);
    }

    private void findClasses(ClassPathEntry entry, Adder adder) throws IOException, ClassNotFoundException {
        for (File path : entry.getClassPaths()) {
            if (!path.exists()) continue;
            if (path.isDirectory()) {
                int index = path.getAbsolutePath().length() + 1;
                this.processDirectory(entry, path, adder, index);
                continue;
            }
            if (!path.getName().endsWith(".jar")) continue;
            this.processJar(entry, path, adder);
        }
    }

    private void processDirectory(ClassPathEntry entry, File path, Adder adder, int index) throws ClassNotFoundException {
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.getName().endsWith(".class")) {
                String clazz = child.getAbsolutePath();
                clazz = clazz.substring(index, clazz.length() - 6);
                if (entry.filter(clazz = clazz.replace(File.separator, "."))) {
                    adder.add(clazz);
                }
            } else if (child.isDirectory()) {
                this.processDirectory(entry, child, adder, index);
            }
            ++n2;
        }
    }

    protected void processJar(ClassPathEntry entry, File path, Adder adder) throws IOException, ClassNotFoundException {
        JarFile jar = new JarFile(path);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry jEntry = entries.nextElement();
            String clazz = jEntry.getName();
            if (!clazz.endsWith(".class")) continue;
            clazz = clazz.replace("/", ".");
            if (!entry.filter(clazz = clazz.substring(0, clazz.length() - 6))) continue;
            adder.add(clazz);
        }
    }

    protected static interface Adder {
        public void add(String var1) throws ClassNotFoundException;
    }

    private static class ClassAdder
    implements Adder {
        Set<Class<?>> classes = new HashSet();
        ClassLoader loader = this.getClass().getClassLoader();

        @Override
        public void add(String clazz) {
            try {
                this.classes.add(Class.forName(clazz, false, this.loader));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static class StringAdder
    implements Adder {
        Set<String> classes = new HashSet<String>();

        @Override
        public void add(String clazz) throws ClassNotFoundException {
            this.classes.add(clazz);
        }
    }
}

