/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.physics;

import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class RigidBodyFactory {
    public static RigidBody createSphereBody(float radius, float mass, float[] loc) {
        SphereShape colShape = new SphereShape(radius);
        RigidBodyConstructionInfo rbInfo = RigidBodyFactory.ConstructBodyInfo((CollisionShape)colShape, mass, loc);
        return new RigidBody(rbInfo);
    }

    public static RigidBody createCubeBody(float edgeLength, float mass, float[] loc) {
        return RigidBodyFactory.createBoxBody(edgeLength, edgeLength, edgeLength, mass, loc);
    }

    public static RigidBody createBoxBody(float xLength, float yLength, float zLength, float mass, float[] loc) {
        Vector3f extents = new Vector3f(xLength / 2.0f, yLength / 2.0f, zLength / 2.0f);
        BoxShape colShape = new BoxShape(extents);
        RigidBodyConstructionInfo rbInfo = RigidBodyFactory.ConstructBodyInfo((CollisionShape)colShape, mass, loc);
        return new RigidBody(rbInfo);
    }

    protected static RigidBodyConstructionInfo ConstructBodyInfo(CollisionShape colShape, float mass, float[] loc) {
        Vector3f localInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        if (mass != 0.0f) {
            colShape.calculateLocalInertia(mass, localInertia);
        }
        Transform startTransform = new Transform();
        startTransform.setIdentity();
        startTransform.origin.set((Tuple3f)new Vector3f(loc));
        DefaultMotionState myMotionState = new DefaultMotionState(startTransform);
        return new RigidBodyConstructionInfo(mass, (MotionState)myMotionState, colShape, localInertia);
    }
}

