/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.physics;

import com.bulletphysics.collision.broadphase.AxisSweep3;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.linearmath.Transform;
import java.util.HashMap;
import javax.vecmath.Vector3f;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.space.continuous.ContinuousAdder;
import repast.simphony.space.continuous.DefaultContinuousSpace;
import repast.simphony.space.continuous.MultiOccupancyCoordinateAccessor;
import repast.simphony.space.continuous.PointTranslator;
import repast.simphony.space.physics.PhysicsScheduleAction;
import repast.simphony.space.physics.PhysicsSpace;

public class DefaultPhysicsSpace<T>
extends DefaultContinuousSpace<T>
implements PhysicsSpace<T> {
    protected CollisionConfiguration collisionConfiguration;
    protected CollisionDispatcher dispatcher;
    protected SequentialImpulseConstraintSolver solver;
    protected DiscreteDynamicsWorld dynamicsWorld;
    protected HashMap<RigidBody, T> bodyToObjectMap;
    protected HashMap<T, RigidBody> objectToBodyMap;
    protected float stepSize = 0.016666668f;
    protected int maxSubSteps = 0;

    public DefaultPhysicsSpace(String name, ContinuousAdder<T> adder, PointTranslator translator, double xdim, double ydim, double zdim) {
        super(name, adder, translator, new MultiOccupancyCoordinateAccessor(), new double[]{xdim, ydim, zdim});
        this.initPhysics(true);
    }

    public DefaultPhysicsSpace(String name, ContinuousAdder<T> adder, PointTranslator translator, double[] size, double[] origin) {
        super(name, adder, translator, size, origin);
        this.initPhysics(true);
    }

    protected void initPhysics(boolean scheduleStep) {
        this.bodyToObjectMap = new HashMap();
        this.objectToBodyMap = new HashMap();
        this.collisionConfiguration = new DefaultCollisionConfiguration();
        this.dispatcher = new CollisionDispatcher(this.collisionConfiguration);
        Vector3f worldAabbMin = new Vector3f(-1000.0f, -1000.0f, -1000.0f);
        Vector3f worldAabbMax = new Vector3f(1000.0f, 1000.0f, 1000.0f);
        int maxProxies = 16384;
        AxisSweep3 overlappingPairCache = new AxisSweep3(worldAabbMin, worldAabbMax, maxProxies);
        this.solver = new SequentialImpulseConstraintSolver();
        this.dynamicsWorld = new DiscreteDynamicsWorld((Dispatcher)this.dispatcher, (BroadphaseInterface)overlappingPairCache, (ConstraintSolver)this.solver, this.collisionConfiguration);
        this.dynamicsWorld.setGravity(new Vector3f(0.0f, -9.8f, 0.0f));
        if (scheduleStep) {
            ScheduleParameters params = ScheduleParameters.createRepeating(0.0, 1.0);
            ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
            schedule.schedule(params, new PhysicsScheduleAction(this));
        }
    }

    @Override
    public boolean addObject(T object, RigidBody body) {
        if (!this.bodyToObjectMap.values().contains(object)) {
            this.dynamicsWorld.addRigidBody(body);
            this.bodyToObjectMap.put(body, object);
            this.objectToBodyMap.put(object, body);
        }
        Transform trans = new Transform();
        body.getMotionState().getWorldTransform(trans);
        return super.moveTo(object, trans.origin.x, trans.origin.y, trans.origin.z);
    }

    @Override
    public Transform getTransformForObject(T object) {
        return this.objectToBodyMap.get(object).getWorldTransform(new Transform());
    }

    @Override
    public void step() {
        this.dynamicsWorld.stepSimulation(this.stepSize, this.maxSubSteps);
        int j = this.dynamicsWorld.getNumCollisionObjects() - 1;
        while (j >= 0) {
            CollisionObject obj = (CollisionObject)this.dynamicsWorld.getCollisionObjectArray().get(j);
            RigidBody body = RigidBody.upcast((CollisionObject)obj);
            if (body != null && body.getMotionState() != null) {
                Transform trans = body.getMotionState().getWorldTransform(new Transform());
                if (this.bodyToObjectMap.get(body) != null) {
                    super.moveTo(this.bodyToObjectMap.get(body), trans.origin.x, trans.origin.y, trans.origin.z);
                }
            }
            --j;
        }
    }

    @Override
    public void setLinearVelocity(T object, float x, float y, float z) {
        this.objectToBodyMap.get(object).setLinearVelocity(new Vector3f(x, y, z));
    }

    @Override
    public float[] getLinearVelocity(T object) {
        float[] v = new float[3];
        this.objectToBodyMap.get(object).getLinearVelocity(new Vector3f(0.0f, 0.0f, 0.0f)).get(v);
        return v;
    }

    @Override
    public void setGravity(float x, float y, float z) {
        this.dynamicsWorld.setGravity(new Vector3f(x, y, z));
    }

    @Override
    public float[] getGravity() {
        float[] g = new float[3];
        this.dynamicsWorld.getGravity(new Vector3f(0.0f, 0.0f, 0.0f)).get(g);
        return g;
    }

    @Override
    public float getStepSize() {
        return this.stepSize;
    }

    @Override
    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public int getMaxSubSteps() {
        return this.maxSubSteps;
    }

    @Override
    public void setMaxSubSteps(int maxSubSteps) {
        this.maxSubSteps = maxSubSteps;
    }
}

