/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.SpatialException;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.GridPointTranslator;

public class WrapAroundBorders
implements GridPointTranslator {
    protected transient GridDimensions spaceDimensions;
    protected transient int[] spaceWidths;
    protected transient int[] origin;

    @Override
    public void init(GridDimensions dimensions) {
        this.spaceDimensions = dimensions;
        this.spaceWidths = dimensions.toIntArray(null);
        this.origin = dimensions.originToIntArray(null);
    }

    @Override
    public void translate(int[] location, int ... displacement) {
        int i = 0;
        while (i < displacement.length) {
            location[i] = this.getNewCoord(i, location[i] + displacement[i]);
            ++i;
        }
    }

    @Override
    public void transform(int[] transformedLocation, int ... targetLocation) throws SpatialException {
        int i = 0;
        while (i < targetLocation.length) {
            transformedLocation[i] = this.getNewCoord(i, targetLocation[i]);
            ++i;
        }
    }

    @Override
    public void transform(GridPoint transformedLocation, int ... targetLocation) throws SpatialException {
        this.transform(transformedLocation.point, targetLocation);
    }

    protected int getNewCoord(int dimension, int location) {
        int shiftedLocation = location + this.origin[dimension];
        int value = shiftedLocation % this.spaceWidths[dimension];
        if (value < 0) {
            value = this.spaceWidths[dimension] + value;
        }
        return value - this.origin[dimension];
    }

    @Override
    public boolean isToroidal() {
        return true;
    }
}

