/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;

public class VNContains<T> {
    private Grid<T> grid;
    private GridDimensions dims;
    private int[] tmpPoint;
    private int[] mins;
    private int[] maxs;

    public VNContains(Grid<T> grid) {
        this.grid = grid;
        this.dims = grid.getDimensions();
        int size = this.dims.size();
        if (size > 3 || size < 1) {
            throw new IllegalArgumentException("Von Neuman query is only supported on 1D, 2D and 3D grids");
        }
        this.tmpPoint = new int[size];
        this.mins = new int[size];
        this.maxs = new int[size];
    }

    public boolean isNeighbor(T source, T target, int ... extent) {
        int max;
        if (extent == null || extent.length == 0) {
            extent = new int[this.dims.size()];
            int i = 0;
            while (i < extent.length) {
                extent[i] = 1;
                ++i;
            }
        }
        if (extent.length != this.dims.size()) {
            throw new IllegalArgumentException("Number of extents must match the number of grid dimensions");
        }
        GridPoint point = this.grid.getLocation(source);
        int size = this.dims.size();
        int[] origin = this.dims.originToIntArray(null);
        int i = 0;
        while (i < size) {
            int min;
            int coord = point.getCoord(i);
            max = coord + extent[i];
            this.mins[i] = min = coord - extent[i];
            this.maxs[i] = max;
            if (!this.grid.isPeriodic()) {
                int dimension;
                if (min < -origin[i]) {
                    min = -origin[i];
                }
                if (max > (dimension = this.dims.getDimension(i)) - origin[i] - 1) {
                    max = dimension - origin[i] - 1;
                }
                this.mins[i] = min;
                this.maxs[i] = max;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            int min = this.mins[i];
            max = this.maxs[i];
            point.toIntArray(this.tmpPoint);
            int pVal = point.getCoord(i);
            int j = min;
            while (j <= max) {
                if (j != pVal) {
                    this.tmpPoint[i] = j;
                    Iterable<T> objs = this.grid.getObjectsAt(this.tmpPoint);
                    for (T obj : objs) {
                        if (!target.equals(obj)) continue;
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

