/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.grid.AbstractGridPointTranslator;
import repast.simphony.space.grid.GridDimensions;

public class StickyBorders
extends AbstractGridPointTranslator {
    private transient int[][] spaceMinsMaxes;
    private static final int MIN = 0;
    private static final int MAX = 1;

    @Override
    public void init(GridDimensions dimensions) {
        super.init(dimensions);
        this.spaceMinsMaxes = new int[2][dimensions.size()];
        int[] origin = dimensions.originToIntArray(null);
        int i = 0;
        while (i < dimensions.size()) {
            this.spaceMinsMaxes[0][i] = -origin[i];
            this.spaceMinsMaxes[1][i] = dimensions.getDimension(i) - origin[i] - 1;
            ++i;
        }
    }

    protected int getNewCoord(int dimension, int coord) {
        if (coord < this.spaceMinsMaxes[0][dimension]) {
            return this.spaceMinsMaxes[0][dimension];
        }
        if (coord > this.spaceMinsMaxes[1][dimension]) {
            return this.spaceMinsMaxes[1][dimension];
        }
        return coord;
    }

    @Override
    public void translate(int[] location, int ... displacement) {
        int i = 0;
        while (i < displacement.length) {
            location[i] = this.getNewCoord(i, location[i] + displacement[i]);
            ++i;
        }
    }

    @Override
    public boolean isToroidal() {
        return false;
    }
}

