/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.random.RandomHelper;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridDimensions;
import simphony.util.messages.MessageCenter;

public class RandomGridAdder<T>
implements GridAdder<T> {
    private static final int TRY_WARN_LIMIT = 10000;

    @Override
    public void add(Grid<T> space, T obj) {
        GridDimensions dims = space.getDimensions();
        int[] location = new int[dims.size()];
        this.findLocation(location, dims);
        int tries = 0;
        while (!space.moveTo(obj, location)) {
            this.findLocation(location, dims);
            if (++tries != 10000) continue;
            MessageCenter.getMessageCenter(this.getClass()).warn((Object)("Possible hang in filling grid '" + space.getName() + "': grid may be full. Please reduce number of agents added, use a larger grid, or " + "write a custom GridAdder"), new Object[0]);
        }
    }

    private void findLocation(int[] location, GridDimensions dims) {
        int[] origin = dims.originToIntArray(null);
        int i = 0;
        while (i < location.length) {
            location[i] = RandomHelper.getUniform().nextIntFromTo(0, dims.getDimension(i) - origin[i] - 1);
            ++i;
        }
    }
}

