/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.grid.CellAccessor;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.util.collections.UnremoveableIterator;

public class MultiOccupancyCellAccessor<T>
implements CellAccessor<T, Map<GridPoint, Object>> {
    private static Iterable EMPTY_ITERABLE = new ArrayList();

    @Override
    public T get(Map<GridPoint, Object> locationMap, GridPoint location) {
        List list = (List)locationMap.get(location);
        if (list == null) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public Iterable<T> getAll(Map<GridPoint, Object> locationMap, GridPoint location) {
        List list = (List)locationMap.get(location);
        if (list == null) {
            return EMPTY_ITERABLE;
        }
        return new UnremoveableIterator(list.iterator());
    }

    @Override
    public T getRandom(Map<GridPoint, Object> locationMap, GridPoint location) {
        List list = (List)locationMap.get(location);
        if (list == null) {
            return null;
        }
        return (T)list.get(RandomHelper.nextIntFromTo(0, list.size() - 1));
    }

    @Override
    public boolean put(T obj, Map<GridPoint, Object> locationMap, GridPoint location) {
        ArrayList<T> list = (ArrayList<T>)locationMap.get(location);
        if (list == null) {
            list = new ArrayList<T>();
            locationMap.put(location, list);
        }
        list.add(obj);
        return true;
    }

    @Override
    public boolean allowsMultiOccupancy() {
        return true;
    }

    @Override
    public void remove(T obj, Map<GridPoint, Object> locationMap, GridPoint location) {
        List list = (List)locationMap.get(location);
        if (list != null) {
            list.remove(obj);
            if (list.isEmpty()) {
                locationMap.remove(location);
            }
        }
    }
}

