/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;

public class MooreContains<T> {
    private Grid<T> grid;
    private GridDimensions dims;
    private int[] mins;
    private int[] maxs;

    public MooreContains(Grid<T> grid) {
        this.grid = grid;
        this.dims = grid.getDimensions();
        int size = this.dims.size();
        if (size > 3 || size < 1) {
            throw new IllegalArgumentException("Moore query is only supported on 1D, 2D and 3D grids");
        }
        this.mins = new int[size];
        this.maxs = new int[size];
    }

    public boolean isNeighbor(T source, T target, int ... extent) {
        int py;
        if (extent == null || extent.length == 0) {
            extent = new int[this.dims.size()];
            int i = 0;
            while (i < extent.length) {
                extent[i] = 1;
                ++i;
            }
        }
        if (extent.length != this.dims.size()) {
            throw new IllegalArgumentException("Number of extents must match the number of grid dimensions");
        }
        GridPoint point = this.grid.getLocation(source);
        int px = point.getX();
        int size = this.dims.size();
        int[] origin = this.dims.originToIntArray(null);
        int i = 0;
        while (i < size) {
            int min;
            int coord = point.getCoord(i);
            int max = coord + extent[i];
            this.mins[i] = min = coord - extent[i];
            this.maxs[i] = max;
            if (!this.grid.isPeriodic()) {
                int dimension;
                if (min < -origin[i]) {
                    min = -origin[i];
                }
                if (max > (dimension = this.dims.getDimension(i)) - origin[i] - 1) {
                    max = dimension - origin[i] - 1;
                }
                this.mins[i] = min;
                this.maxs[i] = max;
            }
            ++i;
        }
        if (size == 2) {
            py = point.getY();
            int xMin = this.mins[0];
            int xMax = this.maxs[0];
            int yMin = this.mins[1];
            int yMax = this.maxs[1];
            int x = xMin;
            while (x <= xMax) {
                int y = yMin;
                while (y <= yMax) {
                    if (px != x || py != y) {
                        Iterable<T> objs = this.grid.getObjectsAt(x, y);
                        for (T obj : objs) {
                            if (!target.equals(obj)) continue;
                            return true;
                        }
                    }
                    ++y;
                }
                ++x;
            }
        } else if (size == 3) {
            py = point.getY();
            int pz = point.getZ();
            int xMin = this.mins[0];
            int xMax = this.maxs[0];
            int yMin = this.mins[1];
            int yMax = this.maxs[1];
            int zMin = this.mins[2];
            int zMax = this.maxs[2];
            int z = zMin;
            while (z <= zMax) {
                int x = xMin;
                while (x <= xMax) {
                    int y = yMin;
                    while (y <= yMax) {
                        if (px != x || py != y || pz != z) {
                            Iterable<T> objs = this.grid.getObjectsAt(x, y, z);
                            for (T obj : objs) {
                                if (!target.equals(obj)) continue;
                                return true;
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
                ++z;
            }
        } else {
            int xMin = this.mins[0];
            int xMax = this.maxs[0];
            int x = xMin;
            while (x <= xMax) {
                if (px != x) {
                    Iterable<T> objs = this.grid.getObjectsAt(x);
                    for (T obj : objs) {
                        if (!target.equals(obj)) continue;
                        return true;
                    }
                }
                ++x;
            }
        }
        return false;
    }
}

