/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import java.util.Arrays;

public class GridDimensions {
    int[] dimensions;
    private int hashCode;
    int[] origin;

    public GridDimensions(int ... dimensions) {
        this.dimensions = dimensions;
        this.origin = new int[dimensions.length];
        this.init();
    }

    public GridDimensions(int[] dimensions, int[] origin) {
        this.dimensions = dimensions;
        this.origin = origin;
        this.init();
    }

    public GridDimensions(double ... dimensions) {
        this.dimensions = new int[dimensions.length];
        this.origin = new int[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            this.dimensions[i] = (int)Math.rint(dimensions[i]);
            ++i;
        }
        this.init();
    }

    public GridDimensions(double[] dimensions, double[] origin) {
        this.dimensions = new int[dimensions.length];
        this.origin = new int[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            this.dimensions[i] = (int)Math.rint(dimensions[i]);
            this.origin[i] = (int)Math.rint(origin[i]);
            ++i;
        }
        this.init();
    }

    private void init() {
        if (this.dimensions == null) {
            return;
        }
        this.hashCode = 17;
        int[] nArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            long l = val;
            int hash = (int)(l ^ l >>> 32);
            this.hashCode = 37 * this.hashCode + hash;
            ++n2;
        }
    }

    public int getWidth() {
        return this.dimensions[0];
    }

    public int getHeight() {
        return this.dimensions[1];
    }

    public int getDepth() {
        return this.dimensions[2];
    }

    public int getDimension(int index) {
        return this.dimensions[index];
    }

    public int getOrigin(int index) {
        return this.origin[index];
    }

    public int size() {
        return this.dimensions.length;
    }

    public int[] toIntArray(int[] array) {
        if (array == null) {
            array = new int[this.dimensions.length];
        }
        int i = 0;
        while (i < this.dimensions.length) {
            array[i] = this.dimensions[i];
            ++i;
        }
        return array;
    }

    public int[] originToIntArray(int[] array) {
        if (array == null) {
            array = new int[this.origin.length];
        }
        int i = 0;
        while (i < this.origin.length) {
            array[i] = this.origin[i];
            ++i;
        }
        return array;
    }

    public double[] toDoubleArray(double[] array) {
        if (array == null) {
            array = new double[this.dimensions.length];
        }
        int i = 0;
        while (i < this.dimensions.length) {
            array[i] = this.dimensions[i];
            ++i;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.dimensions);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GridDimensions)) {
            return false;
        }
        GridDimensions other = (GridDimensions)obj;
        if (other.dimensions.length != this.dimensions.length) {
            return false;
        }
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i] != other.dimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

