/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.grid;

import repast.simphony.space.grid.GridAdder;
import repast.simphony.space.grid.GridPointTranslator;
import repast.simphony.space.grid.WrapAroundBorders;

public class GridBuilderParameters<T> {
    protected GridAdder<T> adder;
    protected GridPointTranslator trans;
    protected int[] dims;
    protected int[] origin;
    protected boolean isMulti;

    public GridBuilderParameters(GridPointTranslator borderRule, GridAdder<T> adder, boolean multi, int ... dims) {
        this.adder = adder;
        this.dims = dims;
        this.origin = new int[dims.length];
        this.isMulti = multi;
        this.trans = borderRule;
    }

    public GridBuilderParameters(GridPointTranslator borderRule, GridAdder<T> adder, boolean multi, int[] dims, int[] origin) {
        this.adder = adder;
        this.dims = dims;
        this.origin = origin;
        this.isMulti = multi;
        this.trans = borderRule;
    }

    public GridPointTranslator getGridPointTranslator() {
        return this.trans;
    }

    public GridAdder<T> getAdder() {
        return this.adder;
    }

    public int[] getDimensions() {
        return this.dims;
    }

    public int[] getOrigin() {
        return this.origin;
    }

    public boolean isMultOccupancy() {
        return this.isMulti;
    }

    public static <T> GridBuilderParameters<T> singleOccupancy1D(GridAdder<T> adder, GridPointTranslator borderRule, int size) {
        return new GridBuilderParameters<T>(borderRule, adder, false, size);
    }

    public static <T> GridBuilderParameters<T> singleOccupancy1DTorus(GridAdder<T> adder, int size) {
        return new GridBuilderParameters<T>((GridPointTranslator)new WrapAroundBorders(), adder, false, size);
    }

    public static <T> GridBuilderParameters<T> singleOccupancy2D(GridAdder<T> adder, GridPointTranslator borderRule, int xSize, int ySize) {
        return new GridBuilderParameters<T>(borderRule, adder, false, xSize, ySize);
    }

    public static <T> GridBuilderParameters<T> singleOccupancy2DTorus(GridAdder<T> adder, int xSize, int ySize) {
        return new GridBuilderParameters<T>((GridPointTranslator)new WrapAroundBorders(), adder, false, xSize, ySize);
    }

    public static <T> GridBuilderParameters<T> singleOccupancyND(GridAdder<T> adder, GridPointTranslator borderRule, int ... dimensions) {
        return new GridBuilderParameters<T>(borderRule, adder, false, dimensions);
    }

    public static <T> GridBuilderParameters<T> singleOccupancyNDTorus(GridAdder<T> adder, int ... dimensions) {
        return new GridBuilderParameters<T>((GridPointTranslator)new WrapAroundBorders(), adder, false, dimensions);
    }

    public static <T> GridBuilderParameters<T> multiOccupancy1D(GridAdder<T> adder, GridPointTranslator borderRule, int size) {
        return new GridBuilderParameters<T>(borderRule, adder, true, size);
    }

    public static <T> GridBuilderParameters<T> multiOccupancy1DTorus(GridAdder<T> adder, int size) {
        return new GridBuilderParameters<T>((GridPointTranslator)new WrapAroundBorders(), adder, true, size);
    }

    public static <T> GridBuilderParameters<T> multiOccupancy2D(GridAdder<T> adder, GridPointTranslator borderRule, int xSize, int ySize) {
        return new GridBuilderParameters<T>(borderRule, adder, true, xSize, ySize);
    }

    public static <T> GridBuilderParameters<T> multiOccupancy2DTorus(GridAdder<T> adder, int xSize, int ySize) {
        return new GridBuilderParameters<T>((GridPointTranslator)new WrapAroundBorders(), adder, true, xSize, ySize);
    }

    public static <T> GridBuilderParameters<T> multiOccupancyND(GridAdder<T> adder, GridPointTranslator borderRule, int ... dimensions) {
        return new GridBuilderParameters<T>(borderRule, adder, true, dimensions);
    }

    public static <T> GridBuilderParameters<T> multiOccupancyNDTorus(GridAdder<T> adder, int ... dimensions) {
        return new GridBuilderParameters<T>((GridPointTranslator)new WrapAroundBorders(), adder, true, dimensions);
    }
}

